/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo;

import java.util.Collections;
import java.util.List;
import org.eolang.opeo.Instruction;

public final class OpcodeInstruction
implements Instruction {
    private final int code;
    private final List<Object> arguments;

    public OpcodeInstruction(int code, Object ... args) {
        this(code, List.of(args));
    }

    private OpcodeInstruction(int code, List<Object> args) {
        this.code = code;
        this.arguments = args;
    }

    @Override
    public int opcode() {
        return this.code;
    }

    @Override
    public Object operand(int index) {
        return this.arguments.get(index);
    }

    @Override
    public List<Object> operands() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String toString() {
        return "OpcodeInstruction(code=" + this.code + ", arguments=" + this.arguments + ")";
    }
}

