/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.xembly.Directive;
import org.xembly.Directives;

public interface AstNode {
    public String print();

    public Iterable<Directive> toXmir();

    public List<AstNode> opcodes();

    public static final class Sequence
    implements AstNode {
        private final List<AstNode> nodes;

        public Sequence(List<AstNode> nodes, AstNode ... another) {
            this(Stream.concat(nodes.stream(), Arrays.stream(another)).collect(Collectors.toList()));
        }

        public Sequence(List<AstNode> nodes) {
            this.nodes = nodes;
        }

        @Override
        public String print() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Iterable<Directive> toXmir() {
            Directives directives = new Directives();
            for (AstNode node : this.nodes) {
                directives.append(node.toXmir());
            }
            return directives;
        }

        @Override
        public List<AstNode> opcodes() {
            ArrayList<AstNode> res = new ArrayList<AstNode>(0);
            for (AstNode node : this.nodes) {
                res.addAll(node.opcodes());
            }
            return res;
        }
    }
}

