/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.cactoos.map.MapEntry;

public final class Attributes {
    private final Map<String, String> all;

    public Attributes(String raw) {
        this(Attributes.parse(raw));
    }

    public Attributes(String ... entries) {
        this(Attributes.fromEntries(entries));
    }

    public Attributes(Map<String, String> all) {
        this.all = all;
    }

    public String toString() {
        return this.all.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("|"));
    }

    public String descriptor() {
        return this.find("descriptor");
    }

    public Attributes descriptor(String descriptor) {
        this.all.put("descriptor", descriptor);
        return this;
    }

    public String type() {
        return this.find("type");
    }

    public Attributes type(String type) {
        this.all.put("type", type);
        return this;
    }

    public String owner() {
        return this.find("owner");
    }

    public Attributes owner(String owner) {
        this.all.put("owner", owner);
        return this;
    }

    public String name() {
        return this.find("name");
    }

    public Attributes name(String name) {
        this.all.put("name", name);
        return this;
    }

    private String find(String key) {
        if (this.all.containsKey(key)) {
            return this.all.get(key);
        }
        throw new IllegalArgumentException(String.format("'%s' is not defined: %s", key, this));
    }

    private static Map<String, String> fromEntries(String ... entries) {
        LinkedHashMap<String, String> result;
        int length = entries.length;
        if (length == 0) {
            result = new LinkedHashMap<String, String>(0);
        } else {
            if (length % 2 != 0) {
                throw new IllegalArgumentException("Entries must be even");
            }
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>(0);
            for (int idx = 0; idx < length; idx += 2) {
                res.put(entries[idx], entries[idx + 1]);
            }
            result = res;
        }
        return result;
    }

    private static Map<String, String> parse(String raw) {
        try {
            return Arrays.stream(raw.split("\\|")).map(entry -> entry.split("=")).peek(Attributes::entrySize).map(entry -> new MapEntry((Object)entry[0], (Object)entry[1])).collect(Collectors.toMap(MapEntry::getKey, MapEntry::getValue));
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalArgumentException(String.format("Can't parse attributes '%s'", raw), exception);
        }
    }

    private static void entrySize(String ... entry) {
        if (entry.length != 2) {
            throw new IllegalArgumentException(String.format("Entry must have two parts, but it has %d: %s", entry.length, Arrays.toString(entry)));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attributes)) {
            return false;
        }
        Attributes other = (Attributes)o;
        Map<String, String> this$all = this.all;
        Map<String, String> other$all = other.all;
        return !(this$all == null ? other$all != null : !((Object)this$all).equals(other$all));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $all = this.all;
        result = result * 59 + ($all == null ? 43 : ((Object)$all).hashCode());
        return result;
    }
}

