/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eolang.opeo.ast.AstNode;
import org.eolang.opeo.ast.Attributes;
import org.eolang.opeo.ast.Opcode;
import org.xembly.Directive;
import org.xembly.Directives;

public final class Constructor
implements AstNode {
    private final String type;
    private final Attributes attributes;
    private final List<AstNode> arguments;

    public Constructor(String type, AstNode ... arguments) {
        this(type, Arrays.asList(arguments));
    }

    public Constructor(String type, List<AstNode> arguments) {
        this(type, new Attributes(new String[0]), arguments);
    }

    public Constructor(String type, Attributes attrs, AstNode ... arguments) {
        this(type, attrs, Arrays.asList(arguments));
    }

    public Constructor(String type, Attributes attrs, List<AstNode> args) {
        this.type = type;
        this.attributes = attrs;
        this.arguments = args;
    }

    @Override
    public String print() {
        return String.format("%s.new%s", this.type, this.args());
    }

    @Override
    public Iterable<Directive> toXmir() {
        Directives directives = new Directives();
        directives.add((Object)"o").attr((Object)"base", (Object)".new").attr((Object)"scope", (Object)this.attributes).add((Object)"o").attr((Object)"base", (Object)this.type).up();
        this.arguments.stream().map(AstNode::toXmir).forEach(arg_0 -> ((Directives)directives).append(arg_0));
        return directives.up();
    }

    @Override
    public List<AstNode> opcodes() {
        ArrayList<AstNode> res = new ArrayList<AstNode>(0);
        res.add(new Opcode(187, this.type));
        res.add(new Opcode(89, new Object[0]));
        this.arguments.stream().map(AstNode::opcodes).forEach(res::addAll);
        res.add(new Opcode(183, this.type, "<init>", this.attributes.descriptor()));
        return res;
    }

    private String args() {
        String result = this.arguments.isEmpty() ? "" : this.arguments.stream().map(AstNode::print).map(s -> String.format("(%s)", s)).collect(Collectors.joining(" ", " ", ""));
        return result;
    }
}

