/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eolang.opeo.ast.AstNode;
import org.eolang.opeo.ast.Attributes;
import org.eolang.opeo.ast.Opcode;
import org.xembly.Directive;
import org.xembly.Directives;

public final class Invocation
implements AstNode {
    private final AstNode source;
    private final Attributes attributes;
    private final List<AstNode> arguments;

    public Invocation(AstNode source, String method, AstNode ... args) {
        this(source, method, Arrays.asList(args));
    }

    public Invocation(AstNode source, Attributes attributes, AstNode ... args) {
        this(source, attributes, Arrays.asList(args));
    }

    public Invocation(AstNode source, String method, List<AstNode> arguments) {
        this(source, method, arguments, "V()");
    }

    public Invocation(AstNode source, String method, List<AstNode> arguments, String descriptor) {
        this(source, new Attributes(new String[0]).name(method).descriptor(descriptor), arguments);
    }

    public Invocation(AstNode source, Attributes attributes, List<AstNode> arguments) {
        this.source = source;
        this.attributes = attributes.type("method");
        this.arguments = arguments;
    }

    @Override
    public String print() {
        return String.format("(%s).%s%s", this.source.print(), this.attributes.name(), this.args());
    }

    @Override
    public Iterable<Directive> toXmir() {
        if (Objects.isNull(this.source)) {
            throw new IllegalArgumentException(String.format("Source and method must not be null, but they are %s", this));
        }
        Directives directives = new Directives();
        directives.add((Object)"o").attr((Object)"base", (Object)String.format(".%s", this.attributes.name())).attr((Object)"scope", (Object)this.attributes).append(this.source.toXmir());
        this.arguments.stream().map(AstNode::toXmir).forEach(arg_0 -> ((Directives)directives).append(arg_0));
        return directives.up();
    }

    @Override
    public List<AstNode> opcodes() {
        ArrayList<AstNode> res = new ArrayList<AstNode>(0);
        res.addAll(this.source.opcodes());
        for (int index = this.arguments.size() - 1; index >= 0; --index) {
            res.addAll(this.arguments.get(index).opcodes());
        }
        res.add(new Opcode(182, this.attributes.owner(), this.attributes.name(), this.attributes.descriptor()));
        return res;
    }

    private String args() {
        String result = this.arguments.isEmpty() ? "" : this.arguments.stream().map(AstNode::print).collect(Collectors.joining(" ", " ", ""));
        return result;
    }

    public String toString() {
        return "Invocation(source=" + this.source + ", attributes=" + this.attributes + ", arguments=" + this.arguments + ")";
    }
}

