/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.util.Collections;
import java.util.List;
import org.eolang.jeo.representation.directives.DirectivesData;
import org.eolang.opeo.ast.AstNode;
import org.eolang.opeo.ast.Opcode;
import org.xembly.Directive;

public final class Literal
implements AstNode {
    private final Object object;

    public Literal(Object value) {
        this.object = value;
    }

    @Override
    public Iterable<Directive> toXmir() {
        return new DirectivesData(this.object);
    }

    @Override
    public List<AstNode> opcodes() {
        List<AstNode> result;
        if (this.object instanceof Integer) {
            result = Collections.singletonList(Literal.opcode((Integer)this.object));
        } else if (this.object instanceof String) {
            result = Collections.singletonList(Literal.opcode((String)this.object));
        } else {
            throw new IllegalArgumentException(String.format("Unsupported literal type %s, value is %s", this.object.getClass().getName(), this.object));
        }
        return result;
    }

    @Override
    public String print() {
        String result = this.object instanceof String ? String.format("\"%s\"", this.object) : this.object.toString();
        return result;
    }

    private static Opcode opcode(String value) {
        return new Opcode(18, value);
    }

    private static Opcode opcode(int value) {
        Opcode res;
        switch (value) {
            case 0: {
                res = new Opcode(3, new Object[0]);
                break;
            }
            case 1: {
                res = new Opcode(4, new Object[0]);
                break;
            }
            case 2: {
                res = new Opcode(5, new Object[0]);
                break;
            }
            case 3: {
                res = new Opcode(6, new Object[0]);
                break;
            }
            case 4: {
                res = new Opcode(7, new Object[0]);
                break;
            }
            case 5: {
                res = new Opcode(8, new Object[0]);
                break;
            }
            default: {
                res = new Opcode(16, value);
            }
        }
        return res;
    }
}

