/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eolang.jeo.representation.directives.DirectivesInstruction;
import org.eolang.opeo.ast.AstNode;
import org.xembly.Directive;

public final class Opcode
implements AstNode {
    private static final AtomicBoolean COUNTING = new AtomicBoolean(true);
    private final int bytecode;
    private final List<Object> operands;
    private final boolean counting;

    public Opcode(int opcode, Object ... operands) {
        this(opcode, Arrays.asList(operands));
    }

    public Opcode(int opcode, boolean counting) {
        this(opcode, Collections.emptyList(), counting);
    }

    public Opcode(int opcode, List<Object> operands) {
        this(opcode, operands, COUNTING.get());
    }

    public Opcode(int bytecode, List<Object> operands, boolean counting) {
        this.bytecode = bytecode;
        this.operands = operands;
        this.counting = counting;
    }

    @Override
    public String print() {
        return "opcode";
    }

    @Override
    public Iterable<Directive> toXmir() {
        return new DirectivesInstruction(this.bytecode, this.counting, this.operands.toArray());
    }

    @Override
    public List<AstNode> opcodes() {
        return List.of(this);
    }

    public static void disableCounting() {
        COUNTING.set(false);
    }
}

