/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.Opcodes;

public final class OpcodeName {
    private static final Map<Integer, String> NAMES = OpcodeName.init();
    private static final AtomicInteger DEFAULT = new AtomicInteger(0);
    private final int opcode;
    private final AtomicInteger counter;

    public OpcodeName(int opcode) {
        this(opcode, DEFAULT);
    }

    OpcodeName(int opcode, AtomicInteger counter) {
        this.opcode = opcode;
        this.counter = counter;
    }

    public String simplified() {
        return NAMES.getOrDefault(this.opcode, "UNKNOWN");
    }

    String asString() {
        String opc = NAMES.getOrDefault(this.opcode, "UNKNOWN");
        return String.format("%s-%X", opc, this.counter.incrementAndGet());
    }

    private static Map<Integer, String> init() {
        try {
            HashMap<Integer, String> res = new HashMap<Integer, String>();
            for (Field field : Opcodes.class.getFields()) {
                if (field.getType() != Integer.TYPE) continue;
                res.put(field.getInt(Opcodes.class), field.getName());
            }
            return res;
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException(String.format("Can't retrieve opcode names from '%s'", Opcodes.class), exception);
        }
    }
}

