/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eolang.opeo.ast.AstNode;
import org.eolang.opeo.ast.Opcode;
import org.xembly.Directive;
import org.xembly.Directives;

public final class Super
implements AstNode {
    private final AstNode instance;
    private final List<AstNode> arguments;
    private final String descriptor;

    public Super(AstNode instance, AstNode ... arguments) {
        this(instance, Arrays.asList(arguments));
    }

    public Super(AstNode instance, String descriptor, AstNode ... arguments) {
        this(instance, Arrays.asList(arguments), descriptor);
    }

    public Super(AstNode instance, List<AstNode> arguments) {
        this(instance, arguments, "()V");
    }

    public Super(AstNode instance, List<AstNode> arguments, String descriptor) {
        this.instance = instance;
        this.arguments = arguments;
        this.descriptor = descriptor;
    }

    @Override
    public String print() {
        return String.format("%s.super%s", this.instance.print(), this.args());
    }

    @Override
    public Iterable<Directive> toXmir() {
        Directives directives = new Directives();
        directives.add((Object)"o").attr((Object)"base", (Object)".super").attr((Object)"scope", (Object)this.descriptor).append(this.instance.toXmir());
        this.arguments.stream().map(AstNode::toXmir).forEach(arg_0 -> ((Directives)directives).append(arg_0));
        return directives.up();
    }

    @Override
    public List<AstNode> opcodes() {
        ArrayList<AstNode> res = new ArrayList<AstNode>(2);
        res.addAll(this.instance.opcodes());
        this.arguments.stream().map(AstNode::opcodes).forEach(res::addAll);
        res.add(new Opcode(183, "java/lang/Object", "<init>", this.descriptor));
        return res;
    }

    private String args() {
        String result = this.arguments.isEmpty() ? "" : this.arguments.stream().map(AstNode::print).collect(Collectors.joining(" ", " ", ""));
        return result;
    }
}

