/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.ast;

import java.util.List;
import org.eolang.jeo.representation.xmir.XmlNode;
import org.eolang.opeo.ast.AstNode;
import org.eolang.opeo.ast.Attributes;
import org.eolang.opeo.ast.Opcode;
import org.objectweb.asm.Type;
import org.xembly.Directive;
import org.xembly.Directives;

public final class Variable
implements AstNode {
    private static final String PREFIX = "local";
    private final Attributes attributes;
    private final int identifier;

    public Variable(XmlNode node) {
        this(Variable.vattributes(node), Variable.videntifier(node));
    }

    public Variable(Type type, int identifier) {
        this(type, Operation.LOAD, identifier);
    }

    public Variable(Type type, Operation operation, int identifier) {
        this(new Attributes(new String[0]).descriptor(type.getDescriptor()).type(operation.name()), identifier);
    }

    public Variable(Attributes attributes, int identifier) {
        this.attributes = attributes;
        this.identifier = identifier;
    }

    @Override
    public String print() {
        return String.format("%s%d%s", PREFIX, this.identifier, Type.getType((String)this.attributes.descriptor()).getClassName());
    }

    @Override
    public Iterable<Directive> toXmir() {
        return new Directives().add((Object)"o").attr((Object)"base", (Object)String.format("%s%d", PREFIX, this.identifier)).attr((Object)"scope", (Object)this.attributes).up();
    }

    @Override
    public List<AstNode> opcodes() {
        List<AstNode> result = Operation.valueOf(this.attributes.type()).equals((Object)Operation.LOAD) ? this.load() : this.store();
        return result;
    }

    private List<AstNode> load() {
        Type type = Type.getType((String)this.attributes.descriptor());
        List<AstNode> result = type.equals((Object)Type.INT_TYPE) ? List.of(new Opcode(21, this.identifier)) : (type.equals((Object)Type.DOUBLE_TYPE) ? List.of(new Opcode(24, this.identifier)) : (type.equals((Object)Type.LONG_TYPE) ? List.of(new Opcode(22, this.identifier)) : (type.equals((Object)Type.FLOAT_TYPE) ? List.of(new Opcode(23, this.identifier)) : (type.equals((Object)Type.BOOLEAN_TYPE) ? List.of(new Opcode(21, this.identifier)) : (type.equals((Object)Type.CHAR_TYPE) ? List.of(new Opcode(21, this.identifier)) : (type.equals((Object)Type.BYTE_TYPE) ? List.of(new Opcode(21, this.identifier)) : (type.equals((Object)Type.SHORT_TYPE) ? List.of(new Opcode(21, this.identifier)) : List.of(new Opcode(25, this.identifier)))))))));
        return result;
    }

    private List<AstNode> store() {
        Type type = Type.getType((String)this.attributes.descriptor());
        List<AstNode> result = type.equals((Object)Type.INT_TYPE) ? List.of(new Opcode(54, this.identifier)) : (type.equals((Object)Type.DOUBLE_TYPE) ? List.of(new Opcode(57, this.identifier)) : (type.equals((Object)Type.LONG_TYPE) ? List.of(new Opcode(55, this.identifier)) : (type.equals((Object)Type.FLOAT_TYPE) ? List.of(new Opcode(56, this.identifier)) : (type.equals((Object)Type.BOOLEAN_TYPE) ? List.of(new Opcode(54, this.identifier)) : (type.equals((Object)Type.CHAR_TYPE) ? List.of(new Opcode(54, this.identifier)) : (type.equals((Object)Type.BYTE_TYPE) ? List.of(new Opcode(54, this.identifier)) : (type.equals((Object)Type.SHORT_TYPE) ? List.of(new Opcode(54, this.identifier)) : (type.equals((Object)Type.VOID_TYPE) ? List.of(new Opcode(54, this.identifier)) : List.of(new Opcode(58, this.identifier))))))))));
        return result;
    }

    private static int videntifier(XmlNode node) {
        return Integer.parseInt(((String)node.attribute("base").orElseThrow(() -> new IllegalArgumentException(String.format("Can't recognize variable node: %n%s%nWe expected to find 'base' attribute", node)))).substring(PREFIX.length()));
    }

    private static Attributes vattributes(XmlNode node) {
        return new Attributes((String)node.attribute("scope").orElseThrow(() -> new IllegalArgumentException(String.format("Can't recognize variable node: %n%s%nWe expected to find 'scope' attribute", node))));
    }

    public String toString() {
        return "Variable(attributes=" + this.attributes + ", identifier=" + this.identifier + ", print=" + this.print() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable other = (Variable)o;
        if (this.identifier != other.identifier) {
            return false;
        }
        Attributes this$attributes = this.attributes;
        Attributes other$attributes = other.attributes;
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.identifier;
        Attributes $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public static enum Operation {
        LOAD,
        STORE;

    }
}

