/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.compilation;

import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.eolang.opeo.compilation.JeoCompiler;

public class Compiler {
    private final Path xmirs;
    private final Path output;

    public Compiler(File generated) {
        this(generated.toPath());
    }

    public Compiler(Path generated) {
        this(generated.resolve("opeo-xmir"), generated.resolve("xmir"));
    }

    public Compiler(Path xmirs, Path output) {
        this.xmirs = xmirs;
        this.output = output;
    }

    public void compile() {
        if (!Files.exists(this.xmirs, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The input xmirs folder '%s' doesn't exist", this.xmirs));
        }
        Logger.info((Object)this, (String)"Compiling EO sources from %[file]s", (Object[])new Object[]{this.xmirs});
        Logger.info((Object)this, (String)"Saving new compiled EO sources to %[file]s", (Object[])new Object[]{this.output});
        try (Stream<Path> decompiled = Files.walk(this.xmirs, new FileVisitOption[0]).filter(Compiler::isXmir);){
            Logger.info((Object)this, (String)"Compiled %d sources", (Object[])new Object[]{decompiled.peek(this::compile).count()});
        }
        catch (IOException exception) {
            throw new IllegalStateException(String.format("Some problem with reading XMIRs from the '%s' folder", this.xmirs), exception);
        }
    }

    private void compile(Path xmir) {
        try {
            XML compiled = new JeoCompiler((XML)new XMLDocument(xmir)).compile();
            Path out = this.output.resolve(this.xmirs.relativize(xmir));
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            Files.write(out, compiled.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Logger.info((Object)this, (String)"Compiled %[file]s (%[size]s)", (Object[])new Object[]{out, Files.size(out)});
        }
        catch (IOException exception) {
            throw new IllegalStateException(String.format("Can't compile '%x'", xmir), exception);
        }
    }

    private static boolean isXmir(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".xmir");
    }
}

