/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.compilation;

import java.util.Arrays;
import java.util.stream.Collectors;

public final class HexString {
    private static final int RADIX = 16;
    private final String hex;

    public HexString(String hex) {
        this.hex = hex;
    }

    public String decode() {
        try {
            String result = this.hex.isEmpty() ? "" : Arrays.stream(this.hex.split(" ")).map(ch -> Character.valueOf((char)Integer.parseInt(ch, 16))).map(String::valueOf).collect(Collectors.joining());
            return result;
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException(String.format("Invalid hex string: %s", this.hex), exception);
        }
    }

    int decodeAsInt() {
        return Integer.parseInt(this.hex.trim().replace(" ", ""), 16);
    }

    boolean decodeAsBoolean() {
        String value = this.hex.trim();
        if (value.length() != 2) {
            throw new IllegalArgumentException(String.format("Invalid hex boolean string: %s, the expected size is 2: 01 or 00", this.hex));
        }
        return value.equals("01");
    }
}

