/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.compilation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eolang.jeo.representation.xmir.XmlInstruction;
import org.eolang.jeo.representation.xmir.XmlNode;
import org.eolang.opeo.ast.Add;
import org.eolang.opeo.ast.ArrayConstructor;
import org.eolang.opeo.ast.AstNode;
import org.eolang.opeo.ast.Attributes;
import org.eolang.opeo.ast.ClassField;
import org.eolang.opeo.ast.Constructor;
import org.eolang.opeo.ast.InstanceField;
import org.eolang.opeo.ast.Invocation;
import org.eolang.opeo.ast.Label;
import org.eolang.opeo.ast.Literal;
import org.eolang.opeo.ast.Opcode;
import org.eolang.opeo.ast.StaticInvocation;
import org.eolang.opeo.ast.StoreArray;
import org.eolang.opeo.ast.StoreLocal;
import org.eolang.opeo.ast.Substraction;
import org.eolang.opeo.ast.Super;
import org.eolang.opeo.ast.This;
import org.eolang.opeo.ast.Variable;
import org.eolang.opeo.ast.WriteField;
import org.eolang.opeo.compilation.HexString;
import org.xembly.Xembler;

public final class OpeoNodes {
    private final List<XmlNode> nodes;
    private final AtomicInteger pops;

    public OpeoNodes(AstNode ... nodes) {
        this(Arrays.stream(nodes).map(AstNode::toXmir).map(Xembler::new).map(Xembler::xmlQuietly).map(XmlNode::new).collect(Collectors.toList()));
    }

    public OpeoNodes(List<XmlNode> nodes) {
        this.nodes = nodes;
        this.pops = new AtomicInteger(0);
    }

    List<XmlNode> toJeoNodes() {
        return this.nodes.stream().map(this::opcodes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<XmlNode> opcodes(XmlNode node) {
        return this.node(node).opcodes().stream().map(AstNode::toXmir).map(Xembler::new).map(Xembler::xmlQuietly).map(XmlNode::new).collect(Collectors.toList());
    }

    private AstNode node(XmlNode node) {
        AstNode result;
        String base = (String)node.attribute("base").orElseThrow(() -> new IllegalArgumentException(String.format("Can't recognize node: %n%s%n'base' attribute should be present", node)));
        if (".plus".equals(base)) {
            Attributes attrs = new Attributes((String)node.attribute("scope").orElseThrow());
            List inner = node.children().collect(Collectors.toList());
            AstNode left = this.node((XmlNode)inner.get(0));
            AstNode right = this.node((XmlNode)inner.get(1));
            result = new Add(left, right, attrs);
        } else if (".minus".equals(base)) {
            Attributes attrs = new Attributes((String)node.attribute("scope").orElseThrow());
            List inner = node.children().collect(Collectors.toList());
            AstNode left = this.node((XmlNode)inner.get(0));
            AstNode right = this.node((XmlNode)inner.get(1));
            result = new Substraction(left, right, attrs);
        } else if ("opcode".equals(base)) {
            XmlInstruction instruction = new XmlInstruction(node.node());
            int opcode = instruction.opcode();
            result = new Opcode(opcode, instruction.operands());
        } else if ("label".equals(base)) {
            List inner = node.children().collect(Collectors.toList());
            if (this.pops.get() > 0) {
                result = new AstNode.Sequence(Collections.nCopies(this.pops.get(), new Opcode(87, new Object[0])), new Label(this.node((XmlNode)inner.get(0))));
                this.pops.set(0);
            } else {
                result = new Label(this.node((XmlNode)inner.get(0)));
            }
        } else if ("int".equals(base)) {
            result = new Literal(new HexString(node.text()).decodeAsInt());
        } else if ("string".equals(base)) {
            result = new Literal(new HexString(node.text()).decode());
        } else if (".super".equals(base)) {
            List inner = node.children().collect(Collectors.toList());
            AstNode instance = this.node((XmlNode)inner.get(0));
            List<AstNode> arguments = inner.size() > 1 ? inner.subList(1, inner.size()).stream().map(this::node).collect(Collectors.toList()) : Collections.emptyList();
            result = new Super(instance, arguments, (String)node.attribute("scope").orElseThrow(() -> new IllegalArgumentException("Can't find descriptor for super invocation")));
        } else if ("$".equals(base)) {
            result = new This();
        } else if ("staticfield".equals(base)) {
            result = new ClassField(new Attributes((String)node.attribute("scope").orElseThrow()));
        } else if (base.contains("local")) {
            result = new Variable(node);
        } else if (".writearray".equals(base)) {
            List inner = node.children().collect(Collectors.toList());
            AstNode array = this.node((XmlNode)inner.get(0));
            AstNode index = this.node((XmlNode)inner.get(1));
            AstNode value = this.node((XmlNode)inner.get(2));
            result = new StoreArray(array, index, value);
        } else if (".write".equals(base)) {
            if (node.attribute("scope").isPresent()) {
                List inner = node.children().collect(Collectors.toList());
                AstNode target = this.node((XmlNode)((XmlNode)inner.get(0)).children().collect(Collectors.toList()).get(0));
                AstNode value = this.node((XmlNode)inner.get(1));
                result = new WriteField(target, value, new Attributes((String)node.attribute("scope").orElseThrow()));
            } else {
                List inner = node.children().collect(Collectors.toList());
                AstNode variable = this.node((XmlNode)inner.get(0));
                AstNode value = this.node((XmlNode)inner.get(1));
                result = new StoreLocal(variable, value);
            }
        } else if (".new".equals(base)) {
            List inner = node.children().collect(Collectors.toList());
            String type = (String)((XmlNode)inner.get(0)).attribute("base").orElseThrow(() -> new IllegalArgumentException(String.format("Can't find type of '%s'", base)));
            List<AstNode> arguments = inner.size() > 1 ? inner.subList(1, inner.size()).stream().map(this::node).collect(Collectors.toList()) : Collections.emptyList();
            Attributes attributes = type.equals("org/eolang/benchmark/BA") ? new Attributes(new String[0]).descriptor("(I)V") : new Attributes((String)node.attribute("scope").orElseThrow(() -> new IllegalStateException(String.format("Can't find 'scope' attribute of constructor in node: %n%s%n, type is %s", node, type))));
            result = new Constructor(type, attributes, arguments);
        } else if (".array".equals(base)) {
            List children = node.children().collect(Collectors.toList());
            String type = new HexString(((XmlNode)children.get(0)).text()).decode();
            AstNode size = this.node((XmlNode)children.get(1));
            this.pops.incrementAndGet();
            result = new ArrayConstructor(size, type);
        } else if (!base.isEmpty() && base.charAt(0) == '.') {
            Attributes attributes = new Attributes((String)node.attribute("scope").orElseThrow(() -> new IllegalArgumentException(String.format("Can't find attributes of '%s'", base))));
            if (attributes.owner().equals("org/eolang/benchmark/B") && attributes.type().equals("method") && attributes.descriptor().equals("()I") && attributes.name().equals("bar")) {
                attributes = new Attributes("name=bar|descriptor=()I|owner=org/eolang/benchmark/BA|type=method");
            }
            if ("field".equals(attributes.type())) {
                List inner = node.children().collect(Collectors.toList());
                AstNode target = this.node((XmlNode)inner.get(0));
                result = new InstanceField(target, attributes);
            } else if ("static".equals(attributes.type())) {
                List inner = node.children().collect(Collectors.toList());
                List<AstNode> arguments = inner.isEmpty() ? Collections.emptyList() : inner.stream().map(this::node).collect(Collectors.toList());
                result = new StaticInvocation(attributes, arguments);
            } else {
                List inner = node.children().collect(Collectors.toList());
                AstNode target = this.node((XmlNode)inner.get(0));
                List<AstNode> arguments = inner.size() > 1 ? inner.subList(1, inner.size()).stream().map(this::node).collect(Collectors.toList()) : Collections.emptyList();
                result = new Invocation(target, attributes, arguments);
            }
        } else {
            throw new IllegalArgumentException(String.format("Can't recognize node: %n%s%n", node));
        }
        return result;
    }
}

