/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.decompilation;

import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.eolang.opeo.jeo.JeoDecompiler;

public final class Decompiler {
    private final Path xmirs;
    private final Path output;

    public Decompiler(Path generated) {
        this(generated.resolve("xmir"), generated.resolve("opeo-xmir"));
    }

    public Decompiler(Path xmirs, Path output) {
        this.xmirs = xmirs;
        this.output = output;
    }

    public void decompile() {
        try (Stream<Path> files = Files.walk(this.xmirs, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            Logger.info((Object)this, (String)"Decompiling EO sources from %[file]s", (Object[])new Object[]{this.xmirs});
            Logger.info((Object)this, (String)"Saving new decompiled EO sources to %[file]s", (Object[])new Object[]{this.output});
            Logger.info((Object)this, (String)"Decompiled %d EO sources", (Object[])new Object[]{files.filter(Decompiler::isXmir).peek(this::decompile).count()});
        }
        catch (IOException exception) {
            throw new IllegalStateException(String.format("Can't decompile files from '%s'", this.xmirs), exception);
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalStateException(String.format("Can't decompile files from '%s' directory and save them into '%s', current directory is '%s'", this.xmirs, this.output, Paths.get("", new String[0]).toAbsolutePath()), exception);
        }
    }

    private void decompile(Path path) {
        try {
            XML decompiled = new JeoDecompiler((XML)new XMLDocument(path)).decompile();
            Path out = this.output.resolve(this.xmirs.relativize(path));
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            Files.write(out, decompiled.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Logger.info((Object)this, (String)"Decompiled %[file]s (%[size]s)", (Object[])new Object[]{out, Files.size(out)});
        }
        catch (IllegalArgumentException exception) {
            throw new IllegalStateException(String.format("Can't decompile file '%s' in the '%s' folder and save it into '%s'", path, this.xmirs, this.output), exception);
        }
        catch (FileNotFoundException exception) {
            throw new IllegalStateException(String.format("Can't find the file '%s' for decompilation in the '%s' folder", path, this.xmirs), exception);
        }
        catch (IOException exception) {
            throw new IllegalStateException(String.format("Can't decompile file '%s' in the '%s' folder", path, this.xmirs), exception);
        }
    }

    private static boolean isXmir(Path path) {
        return path.toString().endsWith(".xmir");
    }
}

