/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.decompilation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cactoos.list.ListOf;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapOf;
import org.eolang.opeo.Instruction;
import org.eolang.opeo.ast.Add;
import org.eolang.opeo.ast.ArrayConstructor;
import org.eolang.opeo.ast.AstNode;
import org.eolang.opeo.ast.Attributes;
import org.eolang.opeo.ast.ClassField;
import org.eolang.opeo.ast.Constructor;
import org.eolang.opeo.ast.InstanceField;
import org.eolang.opeo.ast.Invocation;
import org.eolang.opeo.ast.Label;
import org.eolang.opeo.ast.Literal;
import org.eolang.opeo.ast.Mul;
import org.eolang.opeo.ast.Opcode;
import org.eolang.opeo.ast.Reference;
import org.eolang.opeo.ast.Root;
import org.eolang.opeo.ast.StaticInvocation;
import org.eolang.opeo.ast.StoreArray;
import org.eolang.opeo.ast.StoreLocal;
import org.eolang.opeo.ast.Substraction;
import org.eolang.opeo.ast.Super;
import org.eolang.opeo.ast.WriteField;
import org.eolang.opeo.decompilation.LocalVariables;
import org.objectweb.asm.Type;
import org.xembly.Directive;

public final class DecompilerMachine {
    private final Deque<AstNode> stack = new LinkedList<AstNode>();
    private final LocalVariables locals;
    private final Map<Integer, InstructionHandler> handlers;
    private final Map<String, String> arguments;

    public DecompilerMachine() {
        this(new HashMap<String, String>());
    }

    public DecompilerMachine(Map<String, String> args) {
        this(new LocalVariables(), args);
    }

    public DecompilerMachine(LocalVariables locals, Map<String, String> arguments) {
        this.locals = locals;
        this.arguments = arguments;
        this.handlers = new MapOf(new Map.Entry[]{new MapEntry((Object)4, (Object)new IconstHandler()), new MapEntry((Object)5, (Object)new IconstHandler()), new MapEntry((Object)6, (Object)new IconstHandler()), new MapEntry((Object)7, (Object)new IconstHandler()), new MapEntry((Object)8, (Object)new IconstHandler()), new MapEntry((Object)96, (Object)new AddHandler()), new MapEntry((Object)96, (Object)new AddHandler()), new MapEntry((Object)100, (Object)new SubstractionHandler()), new MapEntry((Object)101, (Object)new SubstractionHandler()), new MapEntry((Object)104, (Object)new MulHandler()), new MapEntry((Object)21, (Object)new LoadHandler(Type.INT_TYPE)), new MapEntry((Object)22, (Object)new LoadHandler(Type.LONG_TYPE)), new MapEntry((Object)23, (Object)new LoadHandler(Type.FLOAT_TYPE)), new MapEntry((Object)24, (Object)new LoadHandler(Type.DOUBLE_TYPE)), new MapEntry((Object)25, (Object)new LoadHandler(Type.getType(Object.class))), new MapEntry((Object)54, (Object)new StoreHandler(Type.INT_TYPE)), new MapEntry((Object)55, (Object)new StoreHandler(Type.LONG_TYPE)), new MapEntry((Object)56, (Object)new StoreHandler(Type.FLOAT_TYPE)), new MapEntry((Object)57, (Object)new StoreHandler(Type.DOUBLE_TYPE)), new MapEntry((Object)58, (Object)new StoreHandler(Type.getType(Object.class))), new MapEntry((Object)83, (Object)new StoreToArrayHandler()), new MapEntry((Object)189, (Object)new NewArrayHandler()), new MapEntry((Object)187, (Object)new NewHandler()), new MapEntry((Object)89, (Object)new DupHandler()), new MapEntry((Object)16, (Object)new BipushHandler()), new MapEntry((Object)183, (Object)new InvokespecialHandler()), new MapEntry((Object)182, (Object)new InvokevirtualHandler()), new MapEntry((Object)184, (Object)new InvokestaticHander()), new MapEntry((Object)180, (Object)new GetFieldHandler()), new MapEntry((Object)181, (Object)new PutFieldHnadler()), new MapEntry((Object)178, (Object)new GetStaticHnadler()), new MapEntry((Object)18, (Object)new LdcHandler()), new MapEntry((Object)87, (Object)new PopHandler()), new MapEntry((Object)177, (Object)new ReturnHandler()), new MapEntry((Object)1001, (Object)new LabelHandler())});
    }

    public Iterable<Directive> decompileToXmir(Instruction ... instructions) {
        Arrays.stream(instructions).forEach(inst -> this.handler(inst.opcode()).handle((Instruction)inst));
        return new Root((Collection<AstNode>)new ListOf(this.stack.descendingIterator())).toXmir();
    }

    public String decompile(Instruction ... instructions) {
        Arrays.stream(instructions).forEach(inst -> this.handler(inst.opcode()).handle((Instruction)inst));
        return new Root((Collection<AstNode>)new ListOf(this.stack.descendingIterator())).print();
    }

    private boolean counting() {
        return this.arguments.getOrDefault("counting", "true").equals("true");
    }

    private InstructionHandler handler(int opcode) {
        return this.handlers.getOrDefault(opcode, new UnimplementedHandler());
    }

    private List<AstNode> popArguments(int number) {
        LinkedList<AstNode> args = new LinkedList<AstNode>();
        for (int index = 0; index < number; ++index) {
            args.add(this.stack.pop());
        }
        return args;
    }

    private class GetStaticHnadler
    implements InstructionHandler {
        private GetStaticHnadler() {
        }

        @Override
        public void handle(Instruction instruction) {
            String klass = (String)instruction.operand(0);
            String method = (String)instruction.operand(1);
            String descriptor = (String)instruction.operand(2);
            DecompilerMachine.this.stack.push(new ClassField(klass, method, descriptor));
        }
    }

    private class LabelHandler
    implements InstructionHandler {
        private LabelHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(new Label(new Literal(instruction.operand(0))));
        }
    }

    private class IconstHandler
    implements InstructionHandler {
        private IconstHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            switch (instruction.opcode()) {
                case 4: {
                    DecompilerMachine.this.stack.push(new Literal(1));
                    break;
                }
                case 5: {
                    DecompilerMachine.this.stack.push(new Literal(2));
                    break;
                }
                case 6: {
                    DecompilerMachine.this.stack.push(new Literal(3));
                    break;
                }
                case 7: {
                    DecompilerMachine.this.stack.push(new Literal(4));
                    break;
                }
                case 8: {
                    DecompilerMachine.this.stack.push(new Literal(5));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Instruction %s is not supported yet", instruction));
                }
            }
        }
    }

    private class MulHandler
    implements InstructionHandler {
        private MulHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            if (instruction.opcode() == 104) {
                AstNode right = DecompilerMachine.this.stack.pop();
                AstNode left = DecompilerMachine.this.stack.pop();
                DecompilerMachine.this.stack.push(new Mul(left, right));
            } else {
                DecompilerMachine.this.stack.push(new Opcode(instruction.opcode(), instruction.operands(), DecompilerMachine.this.counting()));
            }
        }
    }

    private class SubstractionHandler
    implements InstructionHandler {
        private SubstractionHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            if (instruction.opcode() == 100) {
                AstNode right = DecompilerMachine.this.stack.pop();
                AstNode left = DecompilerMachine.this.stack.pop();
                DecompilerMachine.this.stack.push(new Substraction(left, right, new Attributes(new String[0]).type("int")));
            } else if (instruction.opcode() == 101) {
                AstNode right = DecompilerMachine.this.stack.pop();
                AstNode left = DecompilerMachine.this.stack.pop();
                DecompilerMachine.this.stack.push(new Substraction(left, right, new Attributes(new String[0]).type("long")));
            } else {
                DecompilerMachine.this.stack.push(new Opcode(instruction.opcode(), instruction.operands(), DecompilerMachine.this.counting()));
            }
        }
    }

    private class AddHandler
    implements InstructionHandler {
        private AddHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            if (instruction.opcode() == 96) {
                AstNode right = DecompilerMachine.this.stack.pop();
                AstNode left = DecompilerMachine.this.stack.pop();
                DecompilerMachine.this.stack.push(new Add(left, right));
            } else if (instruction.opcode() == 97) {
                AstNode right = DecompilerMachine.this.stack.pop();
                AstNode left = DecompilerMachine.this.stack.pop();
                DecompilerMachine.this.stack.push(new Add(left, right, new Attributes(new String[0]).type("long")));
            } else {
                DecompilerMachine.this.stack.push(new Opcode(instruction.opcode(), instruction.operands(), DecompilerMachine.this.counting()));
            }
        }
    }

    private class UnimplementedHandler
    implements InstructionHandler {
        private UnimplementedHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(new Opcode(instruction.opcode(), instruction.operands(), DecompilerMachine.this.counting()));
        }
    }

    private class LdcHandler
    implements InstructionHandler {
        private LdcHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(new Literal(instruction.operand(0)));
        }
    }

    private class InvokestaticHander
    implements InstructionHandler {
        private InvokestaticHander() {
        }

        @Override
        public void handle(Instruction instruction) {
            String owner = (String)instruction.operand(0);
            String method = (String)instruction.operand(1);
            String descriptor = (String)instruction.operand(2);
            List<AstNode> args = DecompilerMachine.this.popArguments(Type.getArgumentCount((String)descriptor));
            DecompilerMachine.this.stack.push(new StaticInvocation(owner, method, descriptor, args));
        }
    }

    private class InvokevirtualHandler
    implements InstructionHandler {
        private InvokevirtualHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            String owner = (String)instruction.operand(0);
            String method = (String)instruction.operand(1);
            String descriptor = (String)instruction.operand(2);
            List<AstNode> args = DecompilerMachine.this.popArguments(Type.getArgumentCount((String)descriptor));
            AstNode source = DecompilerMachine.this.stack.pop();
            DecompilerMachine.this.stack.push(new Invocation(source, new Attributes(new String[0]).name(method).descriptor(descriptor).owner(owner), args));
        }
    }

    private class InvokespecialHandler
    implements InstructionHandler {
        private InvokespecialHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            if (!instruction.operand(1).equals("<init>")) {
                throw new UnsupportedOperationException(String.format("Instruction %s is not supported yet", instruction));
            }
            String descriptor = (String)instruction.operand(2);
            List<AstNode> args = DecompilerMachine.this.popArguments(Type.getArgumentCount((String)descriptor));
            String target = (String)instruction.operand(0);
            if ("java/lang/Object".equals(target)) {
                DecompilerMachine.this.stack.push(new Super(DecompilerMachine.this.stack.pop(), args, descriptor));
            } else {
                ((Reference)DecompilerMachine.this.stack.pop()).link(new Constructor(target, new Attributes(new String[0]).descriptor(descriptor), args));
            }
        }
    }

    private class ReturnHandler
    implements InstructionHandler {
        private ReturnHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(new Opcode(instruction.opcode(), instruction.operands(), DecompilerMachine.this.counting()));
        }
    }

    private class PopHandler
    implements InstructionHandler {
        private PopHandler() {
        }

        @Override
        public void handle(Instruction ignore) {
        }
    }

    private class BipushHandler
    implements InstructionHandler {
        private BipushHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(new Literal(instruction.operand(0)));
        }
    }

    private class PutFieldHnadler
    implements InstructionHandler {
        private PutFieldHnadler() {
        }

        @Override
        public void handle(Instruction instruction) {
            AstNode value = DecompilerMachine.this.stack.pop();
            AstNode target = DecompilerMachine.this.stack.pop();
            Attributes attributes = new Attributes(new String[0]).type("field").owner((String)instruction.operand(0)).name((String)instruction.operand(1)).descriptor((String)instruction.operand(2));
            DecompilerMachine.this.stack.push(new WriteField(target, value, attributes));
        }
    }

    private class GetFieldHandler
    implements InstructionHandler {
        private GetFieldHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            String owner = (String)instruction.operand(0);
            String name = (String)instruction.operand(1);
            String descriptor = (String)instruction.operand(2);
            DecompilerMachine.this.stack.push(new InstanceField(DecompilerMachine.this.stack.pop(), new Attributes(new String[0]).name(name).descriptor(descriptor).owner(owner).type("field")));
        }
    }

    private class DupHandler
    implements InstructionHandler {
        private DupHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(DecompilerMachine.this.stack.peek());
        }
    }

    private class NewHandler
    implements InstructionHandler {
        private NewHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(new Reference());
        }
    }

    private class NewArrayHandler
    implements InstructionHandler {
        private NewArrayHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            String type = (String)instruction.operand(0);
            AstNode size = DecompilerMachine.this.stack.pop();
            Reference reference = new Reference();
            reference.link(new ArrayConstructor(size, type));
            DecompilerMachine.this.stack.push(reference);
        }
    }

    private class StoreToArrayHandler
    implements InstructionHandler {
        private StoreToArrayHandler() {
        }

        @Override
        public void handle(Instruction instruction) {
            AstNode value = DecompilerMachine.this.stack.pop();
            AstNode index = DecompilerMachine.this.stack.pop();
            AstNode array = DecompilerMachine.this.stack.pop();
            if (DecompilerMachine.this.stack.peek() == array) {
                DecompilerMachine.this.stack.pop();
            }
            DecompilerMachine.this.stack.push(new StoreArray(array, index, value));
        }
    }

    private final class StoreHandler
    implements InstructionHandler {
        private final Type type;

        private StoreHandler(Type type) {
            this.type = type;
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(new StoreLocal(DecompilerMachine.this.locals.variable((Integer)instruction.operands().get(0), this.type, false), DecompilerMachine.this.stack.pop()));
        }
    }

    private final class LoadHandler
    implements InstructionHandler {
        private final Type type;

        private LoadHandler(Type type) {
            this.type = type;
        }

        @Override
        public void handle(Instruction instruction) {
            DecompilerMachine.this.stack.push(DecompilerMachine.this.locals.variable((Integer)instruction.operands().get(0), this.type, true));
        }
    }

    private static interface InstructionHandler {
        public void handle(Instruction var1);
    }
}

