/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.opeo.jeo;

import java.util.function.Predicate;
import org.eolang.jeo.representation.xmir.XmlBytecodeEntry;
import org.eolang.jeo.representation.xmir.XmlInstruction;
import org.eolang.jeo.representation.xmir.XmlLabel;
import org.eolang.jeo.representation.xmir.XmlMethod;
import org.eolang.opeo.Instruction;
import org.eolang.opeo.jeo.JeoInstruction;
import org.eolang.opeo.jeo.JeoLabel;

public final class JeoInstructions {
    private final XmlMethod method;

    public JeoInstructions(XmlMethod method) {
        this.method = method;
    }

    public Instruction[] instructions() {
        return (Instruction[])this.method.instructions(new Predicate[0]).stream().map(JeoInstructions::toInstruction).toArray(Instruction[]::new);
    }

    private static Instruction toInstruction(XmlBytecodeEntry entry) {
        Instruction result;
        if (entry instanceof XmlInstruction) {
            result = new JeoInstruction((XmlInstruction)entry);
        } else if (entry instanceof XmlLabel) {
            result = new JeoLabel((XmlLabel)entry);
        } else {
            throw new IllegalArgumentException(String.format("Unknown bytecode entry: %s, class is %s", entry, entry.getClass()));
        }
        return result;
    }
}

