/*
 * Decompiled with CFR 0.152.
 */
package org.epics.gpclient.datasource.ca;

import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.Monitor;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_CTRL_Double;
import gov.aps.jca.dbr.DBR_LABELS_Enum;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.DBR_TIME_Byte;
import gov.aps.jca.dbr.DBR_TIME_Double;
import gov.aps.jca.dbr.DBR_TIME_Enum;
import gov.aps.jca.dbr.DBR_TIME_Float;
import gov.aps.jca.dbr.DBR_TIME_Int;
import gov.aps.jca.dbr.DBR_TIME_Short;
import gov.aps.jca.dbr.DBR_TIME_String;
import gov.aps.jca.event.AccessRightsEvent;
import gov.aps.jca.event.AccessRightsListener;
import gov.aps.jca.event.ConnectionEvent;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.MonitorEvent;
import gov.aps.jca.event.MonitorListener;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.epics.gpclient.ReadCollector;
import org.epics.gpclient.WriteCollector;
import org.epics.gpclient.datasource.MultiplexedChannelHandler;
import org.epics.gpclient.datasource.ca.CAConnectionPayload;
import org.epics.gpclient.datasource.ca.CADataSource;
import org.epics.gpclient.datasource.ca.CAMessagePayload;
import org.epics.gpclient.datasource.ca.types.CATypeAdapter;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListNumber;
import org.epics.util.array.UnsafeUnwrapper;
import org.epics.vtype.VByte;
import org.epics.vtype.VDouble;
import org.epics.vtype.VEnum;
import org.epics.vtype.VFloat;
import org.epics.vtype.VInt;
import org.epics.vtype.VLong;
import org.epics.vtype.VShort;

public class CAChannelHandler
extends MultiplexedChannelHandler<CAConnectionPayload, CAMessagePayload> {
    private static final int LARGE_ARRAY = 10000000;
    private final CADataSource caDataSource;
    private volatile Channel channel;
    private volatile boolean largeArray = false;
    private volatile boolean sentReadOnlyException = false;
    private Monitor valueMonitor;
    private Monitor metadataMonitor;
    private final ConnectionListener connectionListener = new ConnectionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionChanged(ConnectionEvent ev) {
            CAChannelHandler cAChannelHandler = CAChannelHandler.this;
            synchronized (cAChannelHandler) {
                try {
                    if (CADataSource.log.isLoggable(Level.FINEST)) {
                        CADataSource.log.log(Level.FINEST, "JCA connectionChanged for channel {0} event {1}", new Object[]{CAChannelHandler.this.getChannelName(), ev});
                    }
                    final Channel channel = (Channel)ev.getSource();
                    if (ev.isConnected() && channel.getElementCount() >= 10000000 && !CAChannelHandler.this.largeArray) {
                        CAChannelHandler.this.disconnect();
                        CAChannelHandler.this.largeArray = true;
                        CAChannelHandler.this.connect();
                        return;
                    }
                    CAChannelHandler.this.processConnection(new CAConnectionPayload(CAChannelHandler.this, channel, (CAConnectionPayload)CAChannelHandler.this.getConnectionPayload()));
                    if (ev.isConnected()) {
                        if (!channel.getWriteAccess() && !CAChannelHandler.this.sentReadOnlyException) {
                            CAChannelHandler.this.reportExceptionToAllWriters(CAChannelHandler.this.createReadOnlyException());
                            CAChannelHandler.this.sentReadOnlyException = true;
                        }
                        CAChannelHandler.this.setup(channel);
                    } else {
                        CAChannelHandler.this.resetMessage();
                        CAChannelHandler.this.sentReadOnlyException = false;
                    }
                    channel.addAccessRightsListener(new AccessRightsListener(){

                        public void accessRightsChanged(AccessRightsEvent ev) {
                            if (CADataSource.log.isLoggable(Level.FINEST)) {
                                CADataSource.log.log(Level.FINEST, "JCA accessRightsChanged for channel {0} event {1}", new Object[]{CAChannelHandler.this.getChannelName(), ev});
                            }
                            CAChannelHandler.this.processConnection(new CAConnectionPayload(CAChannelHandler.this, channel, (CAConnectionPayload)CAChannelHandler.this.getConnectionPayload()));
                            if (!CAChannelHandler.this.sentReadOnlyException && !channel.getWriteAccess()) {
                                CAChannelHandler.this.reportExceptionToAllWriters(CAChannelHandler.this.createReadOnlyException());
                                CAChannelHandler.this.sentReadOnlyException = true;
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    CAChannelHandler.this.reportExceptionToAllReadersAndWriters(ex);
                }
            }
        }
    };
    private final MonitorListener monitorListener = new MonitorListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void monitorChanged(MonitorEvent event) {
            CAChannelHandler cAChannelHandler = CAChannelHandler.this;
            synchronized (cAChannelHandler) {
                if (CADataSource.log.isLoggable(Level.FINEST)) {
                    CADataSource.log.log(Level.FINEST, "JCA value monitorChanged for channel {0} value {1}, event {2}", new Object[]{CAChannelHandler.this.getChannelName(), CAChannelHandler.this.toStringDBR(event.getDBR()), event});
                }
                DBR metadata = null;
                if (CAChannelHandler.this.getLastMessagePayload() != null) {
                    metadata = ((CAMessagePayload)CAChannelHandler.this.getLastMessagePayload()).getMetadata();
                }
                CAChannelHandler.this.processMessage(new CAMessagePayload(metadata, event));
            }
        }
    };
    private final MonitorListener metadataListener = new MonitorListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void monitorChanged(MonitorEvent ev) {
            CAChannelHandler cAChannelHandler = CAChannelHandler.this;
            synchronized (cAChannelHandler) {
                if (CADataSource.log.isLoggable(Level.FINEST)) {
                    CADataSource.log.log(Level.FINEST, "JCA metadata monitorChanged for channel {0} event {1}", new Object[]{CAChannelHandler.this.getChannelName(), ev});
                }
                MonitorEvent event = null;
                if (CAChannelHandler.this.getLastMessagePayload() != null) {
                    event = ((CAMessagePayload)CAChannelHandler.this.getLastMessagePayload()).getEvent();
                }
                CAChannelHandler.this.processMessage(new CAMessagePayload(ev.getDBR(), event));
            }
        }
    };
    static Pattern rtypeStringPattern = Pattern.compile(".+\\.RTYP.*");

    public CAChannelHandler(String channelName, CADataSource caDataSource) {
        super(channelName);
        this.caDataSource = caDataSource;
    }

    public CADataSource getCADataSource() {
        return this.caDataSource;
    }

    protected void connect() {
        try {
            this.channel = this.largeArray ? this.caDataSource.getContext().createChannel(this.getChannelName(), this.connectionListener, (short)0) : this.caDataSource.getContext().createChannel(this.getChannelName(), this.connectionListener, (short)1);
        }
        catch (CAException ex) {
            this.reportExceptionToAllReadersAndWriters((Exception)((Object)ex));
            CADataSource.log.log(Level.WARNING, "JCA Connection failed", ex);
        }
    }

    protected void disconnect() {
        try {
            if (this.channel.getConnectionState() != Channel.ConnectionState.CLOSED) {
                this.channel.removeConnectionListener(this.connectionListener);
                this.channel.destroy();
            }
        }
        catch (CAException ex) {
            this.reportExceptionToAllReadersAndWriters((Exception)((Object)ex));
            CADataSource.log.log(Level.WARNING, "JCA Disconnect fail", ex);
        }
        finally {
            this.channel = null;
            this.processConnection(null);
        }
    }

    protected boolean isConnected(CAConnectionPayload connPayload) {
        return connPayload != null && connPayload.isChannelConnected();
    }

    protected boolean isWriteConnected(CAConnectionPayload connPayload) {
        return connPayload != null && connPayload.isWriteConnected();
    }

    protected CATypeAdapter findTypeAdapter(ReadCollector<?, ?> cache, CAConnectionPayload connection) {
        return this.caDataSource.getCaTypeSupport().find(cache, connection);
    }

    private void setup(Channel channel) throws CAException {
        DBRType metaType = this.metadataFor(channel);
        if (metaType != null) {
            DBR dbr = channel.get(metaType, 1);
            if (CADataSource.log.isLoggable(Level.FINEST)) {
                CADataSource.log.log(Level.FINEST, "JCA metadata getCompleted for channel {0} event {1}", new Object[]{this.getChannelName(), dbr});
            }
            this.processMessage(new CAMessagePayload(dbr, null));
        }
        if (this.valueMonitor != null) {
            this.valueMonitor.removeMonitorListener(this.monitorListener);
            this.valueMonitor.clear();
            this.valueMonitor = null;
        }
        this.valueMonitor = channel.addMonitor(this.valueTypeFor(channel), this.countFor(channel), this.caDataSource.getMonitorMask(), this.monitorListener);
        if (this.metadataMonitor != null) {
            this.metadataMonitor.removeMonitorListener(this.metadataListener);
            this.metadataMonitor.clear();
            this.metadataMonitor = null;
        }
        if (this.caDataSource.isDbePropertySupported() && metaType != null) {
            this.metadataMonitor = channel.addMonitor(metaType, 1, 8, this.metadataListener);
        }
        channel.getContext().flushIO();
    }

    protected void write(Object newValue) {
        if (newValue instanceof ListNumber) {
            ListNumber data = (ListNumber)newValue;
            UnsafeUnwrapper.Array wrappedArray = UnsafeUnwrapper.wrappedArray((CollectionNumber)data);
            newValue = wrappedArray == null ? UnsafeUnwrapper.wrappedDoubleArray((CollectionNumber)data) : wrappedArray;
        }
        try {
            Object[] val;
            if (newValue instanceof Double[]) {
                CADataSource.log.warning("You are writing a Double[] to channel " + this.getChannelName() + ": use org.epics.util.array.ListDouble instead");
                Double[] dbl = (Double[])newValue;
                val = new double[dbl.length];
                for (int i = 0; i < val.length; ++i) {
                    val[i] = dbl[i];
                }
                newValue = val;
                this.channel.put((double[])newValue);
            } else if (newValue instanceof Integer[]) {
                CADataSource.log.warning("You are writing a Integer[] to channel " + this.getChannelName() + ": use org.epics.util.array.ListInt instead");
                Integer[] ival = (Integer[])newValue;
                val = new int[ival.length];
                for (int i = 0; i < val.length; ++i) {
                    val[i] = ival[i].intValue();
                }
                newValue = val;
                this.channel.put((int[])newValue);
            } else if (newValue instanceof Double) {
                this.channel.put(((Double)newValue).doubleValue());
            } else if (newValue instanceof Integer) {
                this.channel.put(((Integer)newValue).intValue());
            } else if (newValue instanceof BigInteger) {
                this.channel.put(((BigInteger)newValue).intValue());
            } else if (newValue instanceof Short) {
                this.channel.put(((Short)newValue).shortValue());
            } else if (newValue instanceof Float) {
                this.channel.put(((Float)newValue).floatValue());
            } else if (newValue instanceof Byte) {
                this.channel.put(((Byte)newValue).byteValue());
            } else if (newValue instanceof String) {
                if (this.isLongString()) {
                    this.channel.put(CAChannelHandler.toBytes(newValue.toString()));
                } else if (this.channel.getFieldType().isBYTE() && this.channel.getElementCount() > 1) {
                    CADataSource.log.warning("You are writing the String " + newValue + " to BYTE channel " + this.getChannelName() + ": use {\"longString\":true} for support");
                    this.channel.put(CAChannelHandler.toBytes(newValue.toString()));
                } else {
                    this.channel.put(newValue.toString());
                }
            } else if (newValue instanceof byte[]) {
                this.channel.put((byte[])newValue);
            } else if (newValue instanceof short[]) {
                this.channel.put((short[])newValue);
            } else if (newValue instanceof int[]) {
                this.channel.put((int[])newValue);
            } else if (newValue instanceof float[]) {
                this.channel.put((float[])newValue);
            } else if (newValue instanceof double[]) {
                this.channel.put((double[])newValue);
            } else if (newValue instanceof long[]) {
                long[] longs = (long[])newValue;
                double[] value = new double[longs.length];
                for (int i = 0; i < longs.length; ++i) {
                    value[i] = longs[i];
                }
                this.channel.put(value);
            } else if (newValue instanceof VByte) {
                this.channel.put(((VByte)newValue).getValue().byteValue());
            } else if (newValue instanceof VShort) {
                this.channel.put(((VShort)newValue).getValue().shortValue());
            } else if (newValue instanceof VInt) {
                this.channel.put(((VInt)newValue).getValue().intValue());
            } else if (newValue instanceof VLong) {
                long value64 = ((VLong)newValue).getValue();
                int value32 = (int)value64;
                if ((long)value32 == value64) {
                    this.channel.put(value32);
                } else {
                    this.channel.put((double)value64);
                }
            } else if (newValue instanceof VFloat) {
                this.channel.put(((VFloat)newValue).getValue().floatValue());
            } else if (newValue instanceof VDouble) {
                this.channel.put(((VDouble)newValue).getValue().doubleValue());
            } else if (newValue instanceof VEnum) {
                this.channel.put(((VEnum)newValue).getValue());
            } else {
                return;
            }
            this.caDataSource.getContext().flushIO();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void processWriteRequest(WriteCollector.WriteRequest<?> request) {
        try {
            this.write(request.getValue());
            request.writeSuccessful();
        }
        catch (Exception ex) {
            request.writeFailed(ex);
        }
    }

    protected int countFor(Channel channel) {
        if (channel.getElementCount() == 1) {
            return 1;
        }
        if (this.caDataSource.isVarArraySupported()) {
            return 0;
        }
        return channel.getElementCount();
    }

    protected DBRType metadataFor(Channel channel) {
        DBRType type = channel.getFieldType();
        if (type.isBYTE() || type.isSHORT() || type.isINT() || type.isFLOAT() || type.isDOUBLE()) {
            return DBR_CTRL_Double.TYPE;
        }
        if (type.isENUM()) {
            return DBR_LABELS_Enum.TYPE;
        }
        return null;
    }

    protected DBRType valueTypeFor(Channel channel) {
        DBRType type = channel.getFieldType();
        if (type.isBYTE()) {
            return DBR_TIME_Byte.TYPE;
        }
        if (type.isSHORT()) {
            return DBR_TIME_Short.TYPE;
        }
        if (type.isINT()) {
            return DBR_TIME_Int.TYPE;
        }
        if (type.isFLOAT()) {
            return DBR_TIME_Float.TYPE;
        }
        if (type.isDOUBLE()) {
            return DBR_TIME_Double.TYPE;
        }
        if (type.isENUM()) {
            return DBR_TIME_Enum.TYPE;
        }
        if (type.isSTRING()) {
            if (this.caDataSource.isRtypValueOnly() && rtypeStringPattern.matcher(channel.getName()).matches()) {
                return DBR_String.TYPE;
            }
            return DBR_TIME_String.TYPE;
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private Exception createReadOnlyException() {
        return new RuntimeException("'" + this.getChannelName() + "' is read-only");
    }

    private String toStringDBR(DBR value) {
        StringBuilder builder = new StringBuilder();
        if (value == null) {
            return "null";
        }
        if (value.getValue() instanceof double[]) {
            builder.append(Arrays.toString((double[])value.getValue()));
        } else if (value.getValue() instanceof short[]) {
            builder.append(Arrays.toString((short[])value.getValue()));
        } else if (value.getValue() instanceof String[]) {
            builder.append(Arrays.toString((String[])value.getValue()));
        } else {
            builder.append(value.getValue().toString());
        }
        return builder.toString();
    }

    static byte[] toBytes(String text) {
        byte[] bytes = new byte[text.length() + 1];
        System.arraycopy(text.getBytes(), 0, bytes, 0, text.length());
        bytes[text.length()] = 0;
        return bytes;
    }

    static String toString(byte[] data) {
        int index;
        for (index = 0; index < data.length && data[index] != 0; ++index) {
        }
        return new String(data, 0, index);
    }

    public boolean isLongString() {
        return false;
    }
}

