/*
 * Decompiled with CFR 0.152.
 */
package org.epics.gpclient.datasource.ca;

import com.cosylab.epics.caj.CAJContext;
import gov.aps.jca.CAException;
import gov.aps.jca.Context;
import gov.aps.jca.JCALibrary;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.gpclient.datasource.ChannelHandler;
import org.epics.gpclient.datasource.DataSource;
import org.epics.gpclient.datasource.ca.CAChannelHandler;
import org.epics.gpclient.datasource.ca.types.CATypeSupport;
import org.epics.gpclient.datasource.ca.types.CAVTypeAdapterSet;

public class CADataSource
extends DataSource {
    static final Logger log = Logger.getLogger(CADataSource.class.getName());
    private Context context;
    private int monitorMask = 5;
    private boolean dbePropertySupported = false;
    private boolean varArraySupported = true;
    private boolean rtypValueOnly = false;
    private boolean honorZeroPrecision = true;
    private final CATypeSupport caTypeSupport = new CATypeSupport(new CAVTypeAdapterSet());

    public CADataSource() {
        try {
            JCALibrary jca = JCALibrary.getInstance();
            this.context = jca.createContext("com.cosylab.epics.caj.CAJContext");
        }
        catch (CAException ex) {
            log.log(Level.SEVERE, "JCA context creation failed", ex);
            throw new RuntimeException("JCA context creation failed", ex);
        }
        try {
            if (this.context instanceof CAJContext) {
                ((CAJContext)this.context).setDoNotShareChannels(true);
            }
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Couldn't change CAJContext to doNotShareChannels: this may cause some rare notification problems.", t);
        }
        try {
            Class<?> cajClazz = Class.forName("com.cosylab.epics.caj.CAJContext");
            if (cajClazz.isInstance(this.context)) {
                this.varArraySupported = this.context.getVersion().getMajorVersion() > 1 || this.context.getVersion().getMinorVersion() > 1 || this.context.getVersion().getMaintenanceVersion() > 9;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Context getContext() {
        return this.context;
    }

    public CATypeSupport getCaTypeSupport() {
        return this.caTypeSupport;
    }

    public int getMonitorMask() {
        return this.monitorMask;
    }

    public boolean isDbePropertySupported() {
        return this.dbePropertySupported;
    }

    public boolean isVarArraySupported() {
        return this.varArraySupported;
    }

    public boolean isRtypValueOnly() {
        return this.rtypValueOnly;
    }

    public boolean isHonorZeroPrecision() {
        return this.honorZeroPrecision;
    }

    protected ChannelHandler createChannel(String channelName) {
        log.log(Level.INFO, "CREATE channel " + channelName);
        return new CAChannelHandler(channelName, this);
    }

    public void close() {
        this.context.dispose();
    }
}

