/*
 * Decompiled with CFR 0.152.
 */
package org.epics.gpclient.datasource.ca.types;

import gov.aps.jca.ValuedEnum;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.TimeStamp;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.epics.util.text.NumberFormats;
import org.epics.vtype.Alarm;
import org.epics.vtype.AlarmSeverity;
import org.epics.vtype.AlarmStatus;
import org.epics.vtype.Time;

public class CADataUtils {
    static long TS_EPOCH_SEC_PAST_1970 = 631152000L;

    public static Alarm fromEpics(Severity severity) {
        if (Severity.NO_ALARM.isEqualTo((ValuedEnum)severity)) {
            return Alarm.none();
        }
        if (Severity.MINOR_ALARM.isEqualTo((ValuedEnum)severity)) {
            return Alarm.of((AlarmSeverity)AlarmSeverity.MINOR, (AlarmStatus)AlarmStatus.RECORD, (String)"");
        }
        if (Severity.MAJOR_ALARM.isEqualTo((ValuedEnum)severity)) {
            return Alarm.of((AlarmSeverity)AlarmSeverity.MAJOR, (AlarmStatus)AlarmStatus.RECORD, (String)"");
        }
        if (Severity.INVALID_ALARM.isEqualTo((ValuedEnum)severity)) {
            return Alarm.of((AlarmSeverity)AlarmSeverity.INVALID, (AlarmStatus)AlarmStatus.RECORD, (String)"");
        }
        return Alarm.of((AlarmSeverity)AlarmSeverity.UNDEFINED, (AlarmStatus)AlarmStatus.UNDEFINED, (String)"");
    }

    public static Time timestampOf(TimeStamp timeStamp) {
        if (timeStamp == null) {
            return null;
        }
        return Time.of((Instant)Instant.ofEpochSecond(timeStamp.secPastEpoch() + TS_EPOCH_SEC_PAST_1970, 0L).plus(timeStamp.nsec(), ChronoUnit.NANOS));
    }

    public static NumberFormat getFormat(DBR metadata, boolean honorZeroPrecision) {
        int precision = -1;
        if (metadata instanceof PRECISION) {
            precision = ((PRECISION)metadata).getPrecision();
        }
        if (precision < 0) {
            return NumberFormats.toStringFormat();
        }
        if (precision == 0) {
            if (honorZeroPrecision) {
                return NumberFormats.precisionFormat((int)0);
            }
            return NumberFormats.toStringFormat();
        }
        return NumberFormats.precisionFormat((int)precision);
    }
}

