/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.sample.SetupUtil;
import org.epics.pvmanager.vtype.ExpressionLanguage;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VStatistics;

public class CAPVFrame
extends JFrame {
    PVReader<VStatistics> pv;
    private JButton createPVButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JTextField pvNameField;
    private JSpinner scanRateSpinner;
    private JLabel valueLabel;

    public CAPVFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.valueLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.pvNameField = new JTextField();
        this.jLabel6 = new JLabel();
        this.scanRateSpinner = new JSpinner();
        this.createPVButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("PV value:");
        this.valueLabel.setText("0");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("PV parameters"));
        this.jLabel3.setText("PV Name:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pvNameField, -1, 144, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.pvNameField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel6.setText("UI scan rate (Hz):");
        this.scanRateSpinner.setModel(new SpinnerNumberModel(1, 1, 50, 1));
        this.createPVButton.setText("Create ");
        this.createPVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CAPVFrame.this.createPVButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.createPVButton, -1, 242, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueLabel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanRateSpinner, -1, 135, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.valueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.scanRateSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.createPVButton).addContainerGap()));
        this.pack();
    }

    private void createPVButtonActionPerformed(ActionEvent evt) {
        if ("".equals(this.pvNameField.getText())) {
            return;
        }
        if (this.pv != null) {
            this.pv.close();
        }
        int scanRate = (Integer)this.scanRateSpinner.getModel().getValue();
        this.pv = PVManager.read((DesiredRateExpression)ExpressionLanguage.statisticsOf((SourceRateExpression)ExpressionLanguage.vDouble((String)this.pvNameField.getText()))).maxRate(TimeDuration.ofHertz((double)scanRate));
        this.pv.addPVReaderListener((PVReaderListener)new PVReaderListener<VStatistics>(){

            public void pvChanged(PVReaderEvent<VStatistics> event) {
                if (CAPVFrame.this.pv.getValue() != null) {
                    CAPVFrame.this.valueLabel.setText(Double.toString(((VStatistics)CAPVFrame.this.pv.getValue()).getAverage()) + " \u00b1 " + Double.toString(((VStatistics)CAPVFrame.this.pv.getValue()).getStdDev()));
                }
            }
        });
    }

    public static void main(String[] args) {
        SetupUtil.defaultCASetupForSwing();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CAPVFrame().setVisible(true);
            }
        });
    }
}

