/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.jca.JCADataSource;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VDoubleArray;
import org.epics.vtype.VShortArray;

public class JCALargeArrays {
    static long start = System.currentTimeMillis();

    public static void main(String[] args) throws Exception {
        System.setProperty("com.cosylab.epics.caj.CAJContext.max_array_bytes", "1");
        JCADataSource source = new JCADataSource();
        source.getContext().printInfo();
        PVManager.setDefaultDataSource((DataSource)source);
        PVReader pv = PVManager.read((SourceRateExpression)ExpressionLanguage.channel((String)"carcassi:compressExample2")).readListener((PVReaderListener)new PVReaderListener<Object>(){

            public void pvChanged(PVReaderEvent<Object> event) {
                PVReader pv = event.getPvReader();
                long pause = System.currentTimeMillis() - start;
                start = System.currentTimeMillis();
                if (pv.getValue() instanceof VShortArray) {
                    System.out.println(pause + " ms - " + pv.getValue() + " - count " + ((VShortArray)pv.getValue()).getData().size());
                } else if (pv.getValue() instanceof VDoubleArray) {
                    System.out.println(pause + " ms - " + pv.getValue() + " - count " + ((VDoubleArray)pv.getValue()).getData().size());
                } else {
                    System.out.println(pause + " ms - " + pv.getValue());
                }
                Exception ex = pv.lastException();
                if (ex != null) {
                    ex.printStackTrace();
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)50.0));
        Thread.sleep(5000L);
        pv.close();
        PVManager.getDefaultDataSource().close();
    }
}

