/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.epics.pvmanager.CompositeDataSource;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.PVWriter;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.SourceRateReadWriteExpression;
import org.epics.pvmanager.expression.WriteExpression;
import org.epics.pvmanager.extra.DynamicGroup;
import org.epics.pvmanager.jca.JCADataSource;
import org.epics.pvmanager.loc.LocalDataSource;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.util.Executors;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.SimpleValueFormat;
import org.epics.vtype.VStatistics;
import org.epics.vtype.ValueFormat;
import org.epics.vtype.ValueUtil;

public class MockDynamicTablePVFrame
extends JFrame {
    private DynamicGroup group = org.epics.pvmanager.extra.ExpressionLanguage.group();
    private PVReader<List<Object>> pv = PVManager.read((DesiredRateExpression)this.group).notifyOn(Executors.swingEDT()).maxRate(TimeDuration.ofHertz((double)2.0));
    private List<Object> latestValue = null;
    private List<Exception> latestExceptions = null;
    private List<String> pvNames = new ArrayList<String>();
    private ValueFormat format = new SimpleValueFormat(3);
    private AbstractTableModel model = new AbstractTableModel(){
        private List<String> titles = Arrays.asList("PV name", "Value", "Alarm", "Time");
        {
            MockDynamicTablePVFrame.this.pv.addPVReaderListener((PVReaderListener)new PVReaderListener<List<Object>>(){

                public void pvChanged(PVReaderEvent<List<Object>> event) {
                    MockDynamicTablePVFrame.this.latestValue = (List)MockDynamicTablePVFrame.this.pv.getValue();
                    MockDynamicTablePVFrame.this.latestExceptions = MockDynamicTablePVFrame.this.group.lastExceptions();
                    this.fireTableRowsUpdated(0, this.getRowCount());
                }
            });
        }

        @Override
        public String getColumnName(int column) {
            return this.titles.get(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return MockDynamicTablePVFrame.this.pvNames.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return this.titles.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (rowIndex >= MockDynamicTablePVFrame.this.pvNames.size()) {
                        return "";
                    }
                    return MockDynamicTablePVFrame.this.pvNames.get(rowIndex);
                }
                case 1: {
                    if (MockDynamicTablePVFrame.this.latestValue == null || rowIndex >= MockDynamicTablePVFrame.this.latestValue.size()) {
                        return "";
                    }
                    return MockDynamicTablePVFrame.this.format.format(MockDynamicTablePVFrame.this.latestValue.get(rowIndex));
                }
                case 2: {
                    if (MockDynamicTablePVFrame.this.latestValue == null || rowIndex >= MockDynamicTablePVFrame.this.latestValue.size()) {
                        return "";
                    }
                    return this.alarmSeverityOf(MockDynamicTablePVFrame.this.latestValue.get(rowIndex));
                }
                case 3: {
                    if (MockDynamicTablePVFrame.this.latestValue == null || rowIndex >= MockDynamicTablePVFrame.this.latestValue.size()) {
                        return "";
                    }
                    return this.timeStampOf(MockDynamicTablePVFrame.this.latestValue.get(rowIndex));
                }
            }
            throw new RuntimeException();
        }

        private String alarmSeverityOf(Object value) {
            if (value == null) {
                return "";
            }
            return ValueUtil.alarmOf((Object)value).getAlarmSeverity().toString();
        }

        private String timeStampOf(Object value) {
            if (value == null) {
                return "";
            }
            return ValueUtil.timeOf((Object)value).getTimestamp().toString();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex != 0) {
                throw new RuntimeException();
            }
            String name = aValue.toString();
            try {
                if (rowIndex == MockDynamicTablePVFrame.this.pvNames.size()) {
                    MockDynamicTablePVFrame.this.group.add((DesiredRateExpression)ExpressionLanguage.latestValueOf((SourceRateReadWriteExpression)ExpressionLanguage.channel((String)name)));
                    MockDynamicTablePVFrame.this.pvNames.add(name);
                } else {
                    MockDynamicTablePVFrame.this.group.set(rowIndex, (DesiredRateExpression)ExpressionLanguage.latestValueOf((SourceRateReadWriteExpression)ExpressionLanguage.channel((String)name)));
                    MockDynamicTablePVFrame.this.pvNames.set(rowIndex, name);
                }
                MockDynamicTablePVFrame.this.latestExceptions = MockDynamicTablePVFrame.this.group.lastExceptions();
                this.fireTableDataChanged();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(MockDynamicTablePVFrame.this, ex.getMessage(), "Can't open pv", 0);
            }
        }
    };
    private AbstractTableModel writeModel = new AbstractTableModel(){
        private List<String> titles = Arrays.asList("PV name", "New Value");
        private List<String> writePvNames = new ArrayList<String>();
        private List<String> writePvValues = new ArrayList<String>();
        private List<PVWriter> pvWriters = new ArrayList<PVWriter>();

        @Override
        public String getColumnName(int column) {
            return this.titles.get(column);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.writePvNames.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return this.titles.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (rowIndex >= this.writePvNames.size()) {
                        return "";
                    }
                    return this.writePvNames.get(rowIndex);
                }
                case 1: {
                    if (rowIndex >= this.writePvValues.size()) {
                        return "";
                    }
                    return this.writePvValues.get(rowIndex);
                }
            }
            throw new RuntimeException();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex > 2) {
                throw new RuntimeException();
            }
            if (columnIndex == 1) {
                this.writePvValues.set(rowIndex, aValue.toString());
                this.pvWriters.get(rowIndex).write((Object)aValue.toString());
            } else {
                String name = aValue.toString();
                try {
                    if (rowIndex == this.writePvNames.size()) {
                        this.pvWriters.add(PVManager.write((WriteExpression)ExpressionLanguage.channel((String)name)).async());
                        this.writePvNames.add(name);
                        this.writePvValues.add("");
                    } else {
                        this.pvWriters.set(rowIndex, PVManager.write((WriteExpression)ExpressionLanguage.channel((String)name)).async());
                        this.writePvNames.set(rowIndex, name);
                        this.writePvValues.set(rowIndex, "");
                    }
                    this.fireTableDataChanged();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(MockDynamicTablePVFrame.this, ex.getMessage(), "Can't open pv", 0);
                }
            }
        }
    };
    List<PVReader<VStatistics>> pvs = new ArrayList<PVReader<VStatistics>>();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable pvTable;
    private JTable writePvTable;

    public MockDynamicTablePVFrame() {
        this.initComponents();
        this.pvTable.setModel(this.model);
        this.writePvTable.setModel(this.writeModel);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (MockDynamicTablePVFrame.this.latestExceptions != null && row < MockDynamicTablePVFrame.this.latestExceptions.size() && MockDynamicTablePVFrame.this.latestExceptions.get(row) != null) {
                    this.setToolTipText(((Exception)MockDynamicTablePVFrame.this.latestExceptions.get(row)).getMessage());
                    result.setForeground(Color.red);
                } else {
                    this.setToolTipText(null);
                    result.setForeground(table.getForeground());
                }
                return result;
            }
        };
        this.pvTable.setDefaultRenderer(String.class, renderer);
        AbstractAction deleteAction = new AbstractAction("delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] viewRows = MockDynamicTablePVFrame.this.pvTable.getSelectedRows();
                for (int i = viewRows.length - 1; i >= 0; --i) {
                    int modelRow = MockDynamicTablePVFrame.this.pvTable.convertRowIndexToModel(viewRows[i]);
                    MockDynamicTablePVFrame.this.group.remove(modelRow);
                    MockDynamicTablePVFrame.this.pvNames.remove(modelRow);
                    MockDynamicTablePVFrame.this.model.fireTableRowsDeleted(modelRow, modelRow);
                }
            }
        };
        this.pvTable.getActionMap().put("delete", deleteAction);
        this.pvTable.getInputMap(1).put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pvTable = new JTable();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.writePvTable = new JTable();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.jScrollPane1.setViewportView(this.pvTable);
        this.jLabel1.setText("Read:");
        this.jScrollPane2.setViewportView(this.writePvTable);
        this.jLabel2.setText("Write:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 739, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 739, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 310, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 117, -2).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
        CompositeDataSource dataSource = new CompositeDataSource();
        dataSource.putDataSource("sim", SimulationDataSource.simulatedData());
        dataSource.putDataSource("ca", (DataSource)new JCADataSource());
        dataSource.putDataSource("loc", (DataSource)new LocalDataSource());
        dataSource.setDefaultDataSource("sim");
        PVManager.setDefaultDataSource((DataSource)dataSource);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MockDynamicTablePVFrame().setVisible(true);
            }
        });
    }
}

