/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Executor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.ExpressionLanguage;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VDouble;

public class MockPVFrame
extends JFrame {
    PVReader<VDouble> pv;
    private JButton createPVButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JSpinner scanRateSpinner;
    private JSpinner updateRateSpinner;
    private JLabel valueLabel;

    public MockPVFrame() {
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
        PVManager.setDefaultDataSource((DataSource)SimulationDataSource.simulatedData());
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.valueLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.scanRateSpinner = new JSpinner();
        this.createPVButton = new JButton();
        this.jLabel3 = new JLabel();
        this.updateRateSpinner = new JSpinner();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("PV value:");
        this.valueLabel.setText("0");
        this.jLabel6.setText("UI scan rate (Hz):");
        this.scanRateSpinner.setModel(new SpinnerNumberModel(1, 1, 50, 1));
        this.createPVButton.setText("Create ");
        this.createPVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockPVFrame.this.createPVButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("PV update rate (Hz):");
        this.updateRateSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueLabel, -1, 197, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.updateRateSpinner, -1, 139, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel6).addGap(10, 10, 10).addComponent(this.scanRateSpinner, -1, 152, Short.MAX_VALUE)).addComponent(this.createPVButton, -1, 248, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.valueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.updateRateSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanRateSpinner, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.createPVButton).addContainerGap()));
        this.pack();
    }

    private void createPVButtonActionPerformed(ActionEvent evt) {
        if (this.pv != null) {
            this.pv.close();
        }
        double timeIntervalSec = 1.0 / (double)((Integer)this.updateRateSpinner.getModel().getValue()).intValue();
        String pvName = "gaussian(0.0, 1.0, " + timeIntervalSec + ")";
        int scanRate = (Integer)this.scanRateSpinner.getModel().getValue();
        this.pv = PVManager.read((SourceRateExpression)ExpressionLanguage.vDouble((String)pvName)).maxRate(TimeDuration.ofHertz((double)scanRate));
        this.pv.addPVReaderListener((PVReaderListener)new PVReaderListener<Object>(){

            public void pvChanged(PVReaderEvent<Object> event) {
                MockPVFrame.this.valueLabel.setText(Double.toString(((VDouble)MockPVFrame.this.pv.getValue()).getValue()));
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MockPVFrame().setVisible(true);
            }
        });
    }
}

