/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.ExpressionLanguage;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.AlarmSeverity;
import org.epics.vtype.VDouble;

public class MockSimPVFrame
extends JFrame {
    Map<AlarmSeverity, Color> severityColor = new EnumMap<AlarmSeverity, Color>(AlarmSeverity.class);
    PVReader<VDouble> pv;
    private JButton createPVButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JTextField pvNameField;
    private JSpinner scanRateSpinner;
    private JLabel valueLabel;

    public MockSimPVFrame() {
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
        PVManager.setDefaultDataSource((DataSource)SimulationDataSource.simulatedData());
        this.initComponents();
        this.severityColor.put(AlarmSeverity.NONE, Color.BLACK);
        this.severityColor.put(AlarmSeverity.MINOR, Color.YELLOW);
        this.severityColor.put(AlarmSeverity.MAJOR, Color.RED);
        this.severityColor.put(AlarmSeverity.INVALID, Color.GRAY);
        this.severityColor.put(AlarmSeverity.UNDEFINED, Color.MAGENTA);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.valueLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.scanRateSpinner = new JSpinner();
        this.createPVButton = new JButton();
        this.jLabel3 = new JLabel();
        this.pvNameField = new JTextField();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("PV value:");
        this.valueLabel.setText("0");
        this.jLabel6.setText("UI scan rate (Hz):");
        this.scanRateSpinner.setModel(new SpinnerNumberModel(1, 1, 50, 1));
        this.createPVButton.setText("Create ");
        this.createPVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockSimPVFrame.this.createPVButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("PV name:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueLabel, -1, 325, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pvNameField, -1, 321, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel6).addGap(10, 10, 10).addComponent(this.scanRateSpinner, -1, 280, Short.MAX_VALUE)).addComponent(this.createPVButton, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.valueLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.pvNameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanRateSpinner, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.createPVButton).addContainerGap()));
        this.pack();
    }

    private void createPVButtonActionPerformed(ActionEvent evt) {
        if (this.pv != null) {
            this.pv.close();
        }
        int scanRate = (Integer)this.scanRateSpinner.getModel().getValue();
        try {
            this.pv = PVManager.read((SourceRateExpression)ExpressionLanguage.vDouble((String)this.pvNameField.getText())).readListener((PVReaderListener)new PVReaderListener<VDouble>(){

                public void pvChanged(PVReaderEvent<VDouble> event) {
                    MockSimPVFrame.this.valueLabel.setText(Double.toString(((VDouble)MockSimPVFrame.this.pv.getValue()).getValue()));
                    MockSimPVFrame.this.valueLabel.setForeground(MockSimPVFrame.this.severityColor.get(((VDouble)MockSimPVFrame.this.pv.getValue()).getAlarmSeverity()));
                }
            }).maxRate(TimeDuration.ofHertz((double)scanRate));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MockSimPVFrame().setVisible(true);
            }
        });
    }
}

