/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.ExpressionLanguage;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VStatistics;

public class MockTablePVFrame
extends JFrame {
    List<PVReader<VStatistics>> pvs = new ArrayList<PVReader<VStatistics>>();
    private JButton createPVButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner nPVSpinner;
    private JTable pvTable;
    private JSpinner scanRateSpinner;
    private JSpinner updateRateSpinner;

    public MockTablePVFrame() {
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
        PVManager.setDefaultDataSource((DataSource)SimulationDataSource.simulatedData());
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pvTable = new JTable();
        this.jLabel6 = new JLabel();
        this.scanRateSpinner = new JSpinner();
        this.createPVButton = new JButton();
        this.jLabel1 = new JLabel();
        this.nPVSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.updateRateSpinner = new JSpinner();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(3);
        this.pvTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Average", "Standard deviation", "Minimum", "Maximum"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.pvTable);
        this.jLabel6.setText("UI scan rate (Hz):");
        this.scanRateSpinner.setModel(new SpinnerNumberModel(1, 1, 50, 1));
        this.createPVButton.setText("Create ");
        this.createPVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockTablePVFrame.this.createPVButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("N PVs:");
        this.nPVSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jLabel3.setText("PV update rate (Hz):");
        this.updateRateSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 719, Short.MAX_VALUE).addComponent(this.createPVButton, GroupLayout.Alignment.LEADING, -1, 719, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanRateSpinner, -1, 629, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nPVSpinner, -1, 684, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateRateSpinner, -1, 616, Short.MAX_VALUE))).addContainerGap()).addComponent(this.jSeparator1, -1, 739, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 384, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.updateRateSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanRateSpinner, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nPVSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createPVButton).addContainerGap()));
        this.pack();
    }

    private void createPVButtonActionPerformed(ActionEvent evt) {
        if (this.pvs != null && !this.pvs.isEmpty()) {
            for (PVReader<VStatistics> pv : this.pvs) {
                pv.close();
            }
        }
        int nPvs = (Integer)this.nPVSpinner.getModel().getValue();
        double timeIntervalSec = 1.0 / (double)((Integer)this.updateRateSpinner.getModel().getValue()).intValue();
        String pvName = "gaussian(0.0, 1.0, " + timeIntervalSec + ")";
        int scanRate = (Integer)this.scanRateSpinner.getModel().getValue();
        final DefaultTableModel model = (DefaultTableModel)this.pvTable.getModel();
        model.setRowCount(nPvs);
        this.pvs.clear();
        int n = 0;
        while (n < nPvs) {
            final PVReader pv = PVManager.read((DesiredRateExpression)ExpressionLanguage.statisticsOf((SourceRateExpression)ExpressionLanguage.vDouble((String)pvName))).maxRate(TimeDuration.ofHertz((double)scanRate));
            final int nRow = n++;
            pv.addPVReaderListener((PVReaderListener)new PVReaderListener<VStatistics>(){

                public void pvChanged(PVReaderEvent<VStatistics> event) {
                    model.setValueAt(((VStatistics)pv.getValue()).getAverage(), nRow, 0);
                    model.setValueAt(((VStatistics)pv.getValue()).getStdDev(), nRow, 1);
                    model.setValueAt(((VStatistics)pv.getValue()).getMin(), nRow, 2);
                    model.setValueAt(((VStatistics)pv.getValue()).getMax(), nRow, 3);
                }
            });
            this.pvs.add((PVReader<VStatistics>)pv);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MockTablePVFrame().setVisible(true);
            }
        });
    }
}

