/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.epics.pvmanager.CompositeDataSource;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.extra.ColorScheme;
import org.epics.pvmanager.extra.WaterfallPlot;
import org.epics.pvmanager.extra.WaterfallPlotParameters;
import org.epics.pvmanager.jca.JCADataSource;
import org.epics.pvmanager.sample.ImagePanel;
import org.epics.pvmanager.sim.SimulationDataSource;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.ExpressionLanguage;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VImage;
import org.epics.vtype.ValueUtil;

public class MockWaterfallPlot
extends JFrame {
    private PVReader<VImage> pv;
    private WaterfallPlot plot;
    final BufferedImage finalBuffer = new BufferedImage(100, 100, 5);
    private JCheckBox adaptiveRangeField;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JTextField lastError;
    private JSpinner pixelDurationField;
    private ImagePanel plotView;
    private JTextField pvName;
    private JCheckBox scrollDownField;

    public MockWaterfallPlot() {
        PVManager.setDefaultNotificationExecutor((Executor)Executors.swingEDT());
        CompositeDataSource dataSource = new CompositeDataSource();
        dataSource.putDataSource("sim", SimulationDataSource.simulatedData());
        dataSource.putDataSource("epics", (DataSource)new JCADataSource());
        dataSource.setDefaultDataSource("sim");
        PVManager.setDefaultDataSource((DataSource)dataSource);
        this.initComponents();
        WaterfallPlotParameters defaults = WaterfallPlotParameters.defaults();
        this.adaptiveRangeField.setSelected(defaults.isAdaptiveRange());
        this.scrollDownField.setSelected(defaults.isScrollDown());
        this.pixelDurationField.setValue(defaults.getPixelDuration().getNanoSec() / 1000000);
        this.plotView.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MockWaterfallPlot.this.plot != null) {
                    MockWaterfallPlot.this.plot.with(new WaterfallPlotParameters[]{WaterfallPlotParameters.height((int)MockWaterfallPlot.this.plotView.getHeight())});
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.pvName = new JTextField();
        this.lastError = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.adaptiveRangeField = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.pixelDurationField = new JSpinner();
        this.scrollDownField = new JCheckBox();
        this.plotView = new ImagePanel();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("PV Name:");
        this.pvName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockWaterfallPlot.this.pvNameActionPerformed(evt);
            }
        });
        this.lastError.setEditable(false);
        this.adaptiveRangeField.setText("Adaptive range");
        this.adaptiveRangeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockWaterfallPlot.this.adaptiveRangeFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setText("ms per pixel:");
        this.pixelDurationField.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)1));
        this.pixelDurationField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MockWaterfallPlot.this.pixelDurationFieldStateChanged(evt);
            }
        });
        this.scrollDownField.setSelected(true);
        this.scrollDownField.setText("Latest on top");
        this.scrollDownField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MockWaterfallPlot.this.scrollDownFieldActionPerformed(evt);
            }
        });
        GroupLayout plotViewLayout = new GroupLayout(this.plotView);
        this.plotView.setLayout(plotViewLayout);
        plotViewLayout.setHorizontalGroup(plotViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 474, Short.MAX_VALUE));
        plotViewLayout.setVerticalGroup(plotViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 223, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 498, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.adaptiveRangeField).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scrollDownField).addGap(239, 239, 239)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.plotView, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pvName, -1, 405, Short.MAX_VALUE)).addComponent(this.lastError, GroupLayout.Alignment.LEADING, -1, 474, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pixelDurationField, -2, 98, -2))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.pvName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.pixelDurationField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.adaptiveRangeField).addComponent(this.scrollDownField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotView, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastError, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void pvNameActionPerformed(ActionEvent evt) {
        if (this.pv != null) {
            this.pv.close();
        }
        this.plot = org.epics.pvmanager.extra.ExpressionLanguage.waterfallPlotOf((SourceRateExpression)ExpressionLanguage.vNumberArray((String)this.pvName.getText())).with(new WaterfallPlotParameters[]{WaterfallPlotParameters.colorScheme((ColorScheme)ColorScheme.multipleRangeGradient((Color)Color.RED, (Color)Color.YELLOW, (Color)Color.BLACK, (Color)Color.WHITE, (Color)Color.YELLOW, (Color)Color.RED)), WaterfallPlotParameters.backgroundColor((int)this.getBackground().getRGB()), WaterfallPlotParameters.adaptiveRange((boolean)this.adaptiveRangeField.isSelected()), WaterfallPlotParameters.scrollDown((boolean)this.scrollDownField.isSelected()), WaterfallPlotParameters.height((int)this.plotView.getHeight()), WaterfallPlotParameters.pixelDuration((TimeDuration)TimeDuration.ofMillis((int)((Number)this.pixelDurationField.getValue()).intValue()))});
        this.pv = PVManager.read((DesiredRateExpression)this.plot).notifyOn(Executors.swingEDT()).readListener((PVReaderListener)new PVReaderListener<VImage>(){

            public void pvChanged(PVReaderEvent<VImage> event) {
                MockWaterfallPlot.this.setLastError(MockWaterfallPlot.this.pv.lastException());
                if (MockWaterfallPlot.this.pv.getValue() != null) {
                    BufferedImage image = ValueUtil.toImage((VImage)((VImage)MockWaterfallPlot.this.pv.getValue()));
                    MockWaterfallPlot.this.plotView.setImage(image);
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)50.0));
    }

    private void pixelDurationFieldStateChanged(ChangeEvent evt) {
        if (this.plot != null) {
            this.plot.with(new WaterfallPlotParameters[]{WaterfallPlotParameters.pixelDuration((TimeDuration)TimeDuration.ofMillis((int)((Number)this.pixelDurationField.getValue()).intValue()))});
        }
    }

    private void scrollDownFieldActionPerformed(ActionEvent evt) {
        if (this.plot != null) {
            this.plot.with(new WaterfallPlotParameters[]{WaterfallPlotParameters.scrollDown((boolean)this.scrollDownField.isSelected())});
        }
    }

    private void adaptiveRangeFieldActionPerformed(ActionEvent evt) {
        if (this.plot != null) {
            this.plot.with(new WaterfallPlotParameters[]{WaterfallPlotParameters.adaptiveRange((boolean)this.adaptiveRangeField.isSelected())});
        }
    }

    private void setLastError(Exception ex) {
        if (ex != null) {
            this.lastError.setText(ex.getMessage());
            Logger.getLogger(MockWaterfallPlot.class.getName()).log(Level.WARNING, "Error", ex);
        } else {
            this.lastError.setText("");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MockWaterfallPlot().setVisible(true);
            }
        });
    }
}

