/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.util.HashMap;
import java.util.Map;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PV;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.PVWriter;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.DesiredRateReadWriteExpression;
import org.epics.pvmanager.expression.DesiredRateReadWriteExpressionList;
import org.epics.pvmanager.expression.SourceRateReadWriteExpressionList;
import org.epics.pvmanager.expression.WriteExpression;
import org.epics.pvmanager.expression.WriteExpressionList;
import org.epics.util.time.TimeDuration;

public class MultipleChannelExamples {
    public void m1_readMultipleChannels() {
        PVReader pvReader = PVManager.read((DesiredRateExpression)ExpressionLanguage.mapOf((DesiredRateReadWriteExpressionList)ExpressionLanguage.latestValueOf((SourceRateReadWriteExpressionList)ExpressionLanguage.channels((String[])new String[]{"one", "two", "three"})))).readListener((PVReaderListener)new PVReaderListener<Map<String, Object>>(){

            public void pvChanged(PVReaderEvent<Map<String, Object>> event) {
                Map map = (Map)event.getPvReader().getValue();
                if (map != null) {
                    System.out.println("one: " + map.get("one") + " - two: " + map.get("two") + " - three: " + map.get("three"));
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
        pvReader.close();
    }

    public void m2_readMultipleChannels() {
        PVWriter pvWriter = PVManager.write((WriteExpression)ExpressionLanguage.mapOf((WriteExpressionList)ExpressionLanguage.channels((String[])new String[]{"one", "two", "three"}))).async();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("one", 1.0);
        values.put("two", 2.0);
        values.put("three", "run");
        pvWriter.write(values);
        pvWriter.close();
    }

    public void m3_readWriteMultipleChannels() {
        PV pv = PVManager.readAndWrite((DesiredRateReadWriteExpression)ExpressionLanguage.mapOf((DesiredRateReadWriteExpressionList)ExpressionLanguage.latestValueOf((SourceRateReadWriteExpressionList)ExpressionLanguage.channels((String[])new String[]{"one", "two", "three"})))).asynchWriteAndMaxReadRate(TimeDuration.ofMillis((int)100));
        pv.close();
    }

    public void m4_renameChannels() {
        PVReader pvReader = PVManager.read((DesiredRateExpression)ExpressionLanguage.mapOf((DesiredRateReadWriteExpressionList)ExpressionLanguage.latestValueOf((SourceRateReadWriteExpressionList)ExpressionLanguage.channel((String)"one").as("setpoint").and((SourceRateReadWriteExpressionList)ExpressionLanguage.channel((String)"two").as("readback")).and((SourceRateReadWriteExpressionList)ExpressionLanguage.channel((String)"three").as("difference"))))).readListener((PVReaderListener)new PVReaderListener<Map<String, Object>>(){

            public void pvChanged(PVReaderEvent<Map<String, Object>> event) {
                Map map = (Map)event.getPvReader().getValue();
                if (map != null) {
                    System.out.println("setpoint: " + map.get("setpoint") + " - readback: " + map.get("readback") + " - difference: " + map.get("difference"));
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
        pvReader.close();
    }

    public void m5_writeOrdering() {
        PVWriter pvWriter = PVManager.write((WriteExpression)ExpressionLanguage.mapOf((WriteExpressionList)ExpressionLanguage.channel((String)"one").and((SourceRateReadWriteExpressionList)ExpressionLanguage.channel((String)"two").after(new String[]{"one"})).and((SourceRateReadWriteExpressionList)ExpressionLanguage.channel((String)"three").after(new String[]{"two"})))).async();
        pvWriter.close();
    }
}

