/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.epics.graphene.SparklineGraph2DRendererUpdate;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.ExpressionLanguage;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.SparklineGraph2DExpression;
import org.epics.pvmanager.sample.ImagePanel;
import org.epics.pvmanager.sample.SetupUtil;
import org.epics.pvmanager.util.Executors;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.VImage;
import org.epics.vtype.ValueUtil;

public class SparklineApp
extends JFrame {
    private PVReader<Graph2DResult> pv;
    protected SparklineGraph2DExpression plot1;
    protected List<ImagePanel> imagePanels = new ArrayList<ImagePanel>();
    protected List<SparklineGraph2DExpression> plots = new ArrayList<SparklineGraph2DExpression>();
    private List<PVReader<Graph2DResult>> pvs = new ArrayList<PVReader<Graph2DResult>>();
    private List<JTextField> pvFields = new ArrayList<JTextField>();
    private JButton configureButton;
    private ImagePanel imagePanel1;
    private ImagePanel imagePanel2;
    private ImagePanel imagePanel3;
    private ImagePanel imagePanel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField lastErrorField;
    private JTextField pvField1;
    private JTextField pvField2;
    private JTextField pvField3;
    private JTextField pvField4;

    public SparklineApp() {
        SetupUtil.defaultCASetupForSwing();
        this.initComponents();
        int nFields = 4;
        this.pvFields.add(this.pvField1);
        this.imagePanels.add(this.imagePanel1);
        this.pvFields.add(this.pvField2);
        this.imagePanels.add(this.imagePanel2);
        this.pvFields.add(this.pvField3);
        this.imagePanels.add(this.imagePanel3);
        this.pvFields.add(this.pvField4);
        this.imagePanels.add(this.imagePanel4);
        for (int i = 0; i < nFields; ++i) {
            this.pvs.add(null);
            this.plots.add(null);
            this.bindResize(i);
            this.bindPvChange(i);
        }
    }

    private void bindResize(final int i) {
        this.imagePanels.get(i).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SparklineApp.this.plots.get(i) != null) {
                    SparklineApp.this.plots.get(i).update((SparklineGraph2DRendererUpdate)((SparklineGraph2DRendererUpdate)SparklineApp.this.plots.get(i).newUpdate().imageHeight(SparklineApp.this.imagePanels.get(i).getHeight())).imageWidth(SparklineApp.this.imagePanels.get(i).getWidth()));
                }
            }
        });
    }

    private void bindPvChange(final int i) {
        this.pvFields.get(i).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SparklineApp.this.pvChange(i);
            }
        });
        this.pvChange(i);
    }

    private void pvChange(final int i) {
        if (this.pvs.get(i) != null) {
            this.pvs.get(i).close();
            this.imagePanels.get(i).setImage(null);
            this.plots.set(i, null);
        }
        if (this.pvFields.get(i).getText() == null || this.pvFields.get(i).getText().trim().isEmpty()) {
            return;
        }
        SparklineGraph2DExpression plot = org.epics.pvmanager.graphene.ExpressionLanguage.sparklineGraphOf((DesiredRateExpression)ExpressionLanguage.formula((String)this.pvFields.get(i).getText()), null, null);
        this.plots.set(i, plot);
        this.plots.get(i).update((SparklineGraph2DRendererUpdate)((SparklineGraph2DRendererUpdate)this.plots.get(i).newUpdate().imageHeight(this.imagePanels.get(i).getHeight())).imageWidth(this.imagePanels.get(i).getWidth()));
        this.pvs.set(i, (PVReader<Graph2DResult>)PVManager.read((DesiredRateExpression)((DesiredRateExpression)this.plots.get(i))).notifyOn(Executors.swingEDT()).readListener((PVReaderListener)new PVReaderListener<Graph2DResult>(){

            public void pvChanged(PVReaderEvent<Graph2DResult> event) {
                SparklineApp.this.setLastError(event.getPvReader().lastException());
                if (event.getPvReader().getValue() != null) {
                    BufferedImage image = ValueUtil.toImage((VImage)((Graph2DResult)event.getPvReader().getValue()).getImage());
                    SparklineApp.this.imagePanels.get(i).setImage(image);
                }
            }
        }).maxRate(TimeDuration.ofHertz((double)50.0)));
    }

    private void initComponents() {
        this.lastErrorField = new JTextField();
        this.configureButton = new JButton();
        this.jPanel1 = new JPanel();
        this.pvField1 = new JTextField();
        this.imagePanel1 = new ImagePanel();
        this.pvField2 = new JTextField();
        this.imagePanel2 = new ImagePanel();
        this.pvField3 = new JTextField();
        this.imagePanel3 = new ImagePanel();
        this.pvField4 = new JTextField();
        this.imagePanel4 = new ImagePanel();
        this.jPanel2 = new JPanel();
        this.setDefaultCloseOperation(3);
        this.lastErrorField.setEditable(false);
        this.configureButton.setText("Configure");
        this.configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SparklineApp.this.configureButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.pvField1.setText("sim://sineWaveform(1, 100, 100, 0.01)");
        this.pvField1.setMinimumSize(new Dimension(200, 22));
        this.pvField1.setPreferredSize(new Dimension(200, 22));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel1.add((Component)this.pvField1, gridBagConstraints);
        GroupLayout imagePanel1Layout = new GroupLayout(this.imagePanel1);
        this.imagePanel1.setLayout(imagePanel1Layout);
        imagePanel1Layout.setHorizontalGroup(imagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        imagePanel1Layout.setVerticalGroup(imagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.imagePanel1, gridBagConstraints);
        this.pvField2.setText("sim://squareWaveform(1.5, 300, 300, 0.01)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel1.add((Component)this.pvField2, gridBagConstraints);
        GroupLayout imagePanel2Layout = new GroupLayout(this.imagePanel2);
        this.imagePanel2.setLayout(imagePanel2Layout);
        imagePanel2Layout.setHorizontalGroup(imagePanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 370, Short.MAX_VALUE));
        imagePanel2Layout.setVerticalGroup(imagePanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 22, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.imagePanel2, gridBagConstraints);
        this.pvField3.setText("sim://triangleWaveform(0.5, 30,200, 0.01)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel1.add((Component)this.pvField3, gridBagConstraints);
        GroupLayout imagePanel3Layout = new GroupLayout(this.imagePanel3);
        this.imagePanel3.setLayout(imagePanel3Layout);
        imagePanel3Layout.setHorizontalGroup(imagePanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 370, Short.MAX_VALUE));
        imagePanel3Layout.setVerticalGroup(imagePanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 22, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.imagePanel3, gridBagConstraints);
        this.pvField4.setText("sim://gaussianWaveform(2,30,300,0.01)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.jPanel1.add((Component)this.pvField4, gridBagConstraints);
        GroupLayout imagePanel4Layout = new GroupLayout(this.imagePanel4);
        this.imagePanel4.setLayout(imagePanel4Layout);
        imagePanel4Layout.setHorizontalGroup(imagePanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 370, Short.MAX_VALUE));
        imagePanel4Layout.setVerticalGroup(imagePanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 22, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.imagePanel4, gridBagConstraints);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, 617, Short.MAX_VALUE).addComponent(this.lastErrorField).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.configureButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, 135, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configureButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastErrorField, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    protected void openConfigurationDialog() {
    }

    private void configureButtonActionPerformed(ActionEvent evt) {
        this.openConfigurationDialog();
    }

    private void setLastError(Exception ex) {
        if (ex != null) {
            this.lastErrorField.setText(ex.getMessage());
            ex.printStackTrace();
        } else {
            this.lastErrorField.setText("");
        }
    }

    public static void main(String[] args) {
        SparklineApp.main(SparklineApp.class);
    }

    public static void main(final Class<? extends SparklineApp> clazz) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SparklineApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SparklineApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SparklineApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SparklineApp.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ((SparklineApp)clazz.newInstance()).setVisible(true);
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(SparklineApp.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(SparklineApp.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }
}

