/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sample;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.ExpressionLanguage;
import org.epics.pvmanager.PV;
import org.epics.pvmanager.PVManager;
import org.epics.pvmanager.PVReader;
import org.epics.pvmanager.PVReaderEvent;
import org.epics.pvmanager.PVReaderListener;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.DesiredRateExpressionList;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.expression.SourceRateReadWriteExpression;
import org.epics.pvmanager.expression.SourceRateReadWriteExpressionList;
import org.epics.pvmanager.vtype.VTableColumn;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;
import org.epics.util.time.TimeDuration;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VDouble;
import org.epics.vtype.VNumber;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VTable;
import org.epics.vtype.VType;
import org.epics.vtype.ValueUtil;

public class VTypeExamples {
    public void v1_readNumericType() {
        PV pv = PVManager.readAndWrite((SourceRateReadWriteExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vNumber((String)"currentRB")).readListener((PVReaderListener)new PVReaderListener<VNumber>(){

            public void pvChanged(PVReaderEvent<VNumber> event) {
                VNumber value = (VNumber)event.getPvReader().getValue();
                if (value != null) {
                    System.out.println(value.getValue() + " " + value.getAlarmSeverity());
                }
            }
        }).asynchWriteAndMaxReadRate(TimeDuration.ofMillis((int)10));
        pv.write((Object)1.0);
        pv.close();
    }

    public void v2_genericReaderExtractParialInformation() {
        PVReader pvReader = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vType((String)"channelName")).readListener((PVReaderListener)new PVReaderListener<VType>(){

            public void pvChanged(PVReaderEvent<VType> event) {
                VType value = (VType)event.getPvReader().getValue();
                Class type = ValueUtil.typeOf((Object)value);
                Alarm alarm = ValueUtil.alarmOf((Object)value);
                Time time = ValueUtil.timeOf((Object)value);
                Double number = ValueUtil.numericValueOf((Object)value);
                Display display = ValueUtil.displayOf((Object)value);
            }
        }).maxRate(TimeDuration.ofMillis((int)10));
    }

    public void v3_genericReaderSwitchOnType() {
        PVReader pvReader = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vType((String)"channelName")).readListener((PVReaderListener)new PVReaderListener<VType>(){

            public void pvChanged(PVReaderEvent<VType> event) {
                if (event.getPvReader().getValue() instanceof VDouble) {
                    VDouble vDouble = (VDouble)event.getPvReader().getValue();
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
    }

    public void v4_readArrays() {
        PVReader pvReader = PVManager.read((SourceRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vNumberArray((String)"channelName")).readListener((PVReaderListener)new PVReaderListener<VNumberArray>(){

            public void pvChanged(PVReaderEvent<VNumberArray> event) {
                if (event.isValueChanged()) {
                    VNumberArray value = (VNumberArray)event.getPvReader().getValue();
                    ListNumber data = value.getData();
                    for (int i = 0; i < data.size(); ++i) {
                        double iValue = data.getDouble(i);
                        System.out.println(iValue);
                    }
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
    }

    public void v5_assemblingNumericArrayFromScalars() {
        List<String> channelNames = Arrays.asList("channel1", "channel2", "channel3", "channel4");
        PVReader pvReader = PVManager.read((DesiredRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vNumberArrayOf((DesiredRateExpressionList)ExpressionLanguage.latestValueOf((SourceRateReadWriteExpressionList)org.epics.pvmanager.vtype.ExpressionLanguage.vNumbers(channelNames)))).readListener((PVReaderListener)new PVReaderListener<VNumberArray>(){

            public void pvChanged(PVReaderEvent<VNumberArray> event) {
                if (event.isValueChanged()) {
                    System.out.println(event.getPvReader().getValue());
                }
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
    }

    public void v6_assemblingTables() {
        List<String> names = Arrays.asList("one", "two", "trhee");
        PVReader pvReader = PVManager.read((DesiredRateExpression)org.epics.pvmanager.vtype.ExpressionLanguage.vTable((VTableColumn[])new VTableColumn[]{org.epics.pvmanager.vtype.ExpressionLanguage.column((String)"Names", (DesiredRateExpressionList)org.epics.pvmanager.vtype.ExpressionLanguage.vStringConstants(names)), org.epics.pvmanager.vtype.ExpressionLanguage.column((String)"Values", (DesiredRateExpressionList)ExpressionLanguage.latestValueOf((SourceRateReadWriteExpressionList)ExpressionLanguage.channels(names)))})).readListener((PVReaderListener)new PVReaderListener<VTable>(){

            public void pvChanged(PVReaderEvent<VTable> pvReader) {
                VTable vTable = (VTable)pvReader.getPvReader().getValue();
                List names = (List)vTable.getColumnData(0);
                ListDouble values = (ListDouble)vTable.getColumnData(1);
            }
        }).maxRate(TimeDuration.ofMillis((int)100));
    }
}

