/*
 * Decompiled with CFR 0.152.
 */
package org.epos.library.style;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.logging.Logger;
import org.epos.library.style.EposStyleObject;

public class EposStyleItem {
    private static final Logger LOGGER = Logger.getGlobal();
    @SerializedName(value="defaultName")
    private EposStyleObject styleName;
    private transient String name;

    public EposStyleItem(String name) {
        this.name = name;
        try {
            Field f = this.getClass().getDeclaredField("styleName");
            SerializedName fieldAnnotation = f.getAnnotation(SerializedName.class);
            InvocationHandler handler = Proxy.getInvocationHandler(fieldAnnotation);
            f.setAccessible(true);
            Field memberValues = handler.getClass().getDeclaredField("memberValues");
            memberValues.setAccessible(true);
            Map maps = (Map)memberValues.get(handler);
            maps.remove("value");
            maps.put("value", name);
            memberValues.set(handler, maps);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.severe("A problem was encountered while overriding annotation or reading field " + e);
        }
    }

    public EposStyleObject getStyleName() {
        return this.styleName;
    }

    public void setStyleName(EposStyleObject styleName) {
        this.styleName = styleName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "EposStyle [styleName=" + this.styleName + "]";
    }
}

