/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * Holds many transaction requests and transaction fee
 */
@Schema(description = "Holds many transaction requests and transaction fee")

public class RequestsHolder {
  @SerializedName("requests")
  private java.util.List<AnyOfRequestsHolderRequestsItems> requests = new java.util.ArrayList<AnyOfRequestsHolderRequestsItems>();

  @SerializedName("fee")
  private Long fee = null;

  @SerializedName("inputsRaw")
  private java.util.List<String> inputsRaw = null;

  @SerializedName("dataInputsRaw")
  private java.util.List<String> dataInputsRaw = null;

  public RequestsHolder requests(java.util.List<AnyOfRequestsHolderRequestsItems> requests) {
    this.requests = requests;
    return this;
  }

  public RequestsHolder addRequestsItem(AnyOfRequestsHolderRequestsItems requestsItem) {
    this.requests.add(requestsItem);
    return this;
  }

   /**
   * Sequence of transaction requests
   * @return requests
  **/
  @Schema(required = true, description = "Sequence of transaction requests")
  public java.util.List<AnyOfRequestsHolderRequestsItems> getRequests() {
    return requests;
  }

  public void setRequests(java.util.List<AnyOfRequestsHolderRequestsItems> requests) {
    this.requests = requests;
  }

  public RequestsHolder fee(Long fee) {
    this.fee = fee;
    return this;
  }

   /**
   * Transaction fee
   * @return fee
  **/
  @Schema(example = "1000000", description = "Transaction fee")
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public RequestsHolder inputsRaw(java.util.List<String> inputsRaw) {
    this.inputsRaw = inputsRaw;
    return this;
  }

  public RequestsHolder addInputsRawItem(String inputsRawItem) {
    if (this.inputsRaw == null) {
      this.inputsRaw = new java.util.ArrayList<String>();
    }
    this.inputsRaw.add(inputsRawItem);
    return this;
  }

   /**
   * List of inputs to be used in serialized form
   * @return inputsRaw
  **/
  @Schema(description = "List of inputs to be used in serialized form")
  public java.util.List<String> getInputsRaw() {
    return inputsRaw;
  }

  public void setInputsRaw(java.util.List<String> inputsRaw) {
    this.inputsRaw = inputsRaw;
  }

  public RequestsHolder dataInputsRaw(java.util.List<String> dataInputsRaw) {
    this.dataInputsRaw = dataInputsRaw;
    return this;
  }

  public RequestsHolder addDataInputsRawItem(String dataInputsRawItem) {
    if (this.dataInputsRaw == null) {
      this.dataInputsRaw = new java.util.ArrayList<String>();
    }
    this.dataInputsRaw.add(dataInputsRawItem);
    return this;
  }

   /**
   * List of data inputs to be used in serialized form
   * @return dataInputsRaw
  **/
  @Schema(description = "List of data inputs to be used in serialized form")
  public java.util.List<String> getDataInputsRaw() {
    return dataInputsRaw;
  }

  public void setDataInputsRaw(java.util.List<String> dataInputsRaw) {
    this.dataInputsRaw = dataInputsRaw;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RequestsHolder requestsHolder = (RequestsHolder) o;
    return Objects.equals(this.requests, requestsHolder.requests) &&
        Objects.equals(this.fee, requestsHolder.fee) &&
        Objects.equals(this.inputsRaw, requestsHolder.inputsRaw) &&
        Objects.equals(this.dataInputsRaw, requestsHolder.dataInputsRaw);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requests, fee, inputsRaw, dataInputsRaw);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RequestsHolder {\n");
    
    sb.append("    requests: ").append(toIndentedString(requests)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    inputsRaw: ").append(toIndentedString(inputsRaw)).append("\n");
    sb.append("    dataInputsRaw: ").append(toIndentedString(dataInputsRaw)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
