/*
 * Ergo Node API
 * API docs for Ergo Node. Models are shared between all Ergo products
 *
 * OpenAPI spec version: 4.0.12
 * Contact: ergoplatform@protonmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package org.ergoplatform.restapi.client;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.math.BigDecimal;
import org.ergoplatform.restapi.client.AvlTreeData;
import org.ergoplatform.restapi.client.PowSolutions;
/**
 * Block header format used for sigma ErgoLikeContext
 */
@Schema(description = "Block header format used for sigma ErgoLikeContext")

public class SigmaHeader {
  @SerializedName("id")
  private String id = null;

  @SerializedName("timestamp")
  private Integer timestamp = null;

  @SerializedName("version")
  private Integer version = null;

  @SerializedName("adProofsRoot")
  private String adProofsRoot = null;

  @SerializedName("adProofsId")
  private String adProofsId = null;

  @SerializedName("stateRoot")
  private AvlTreeData stateRoot = null;

  @SerializedName("transactionsRoot")
  private String transactionsRoot = null;

  @SerializedName("transactionsId")
  private String transactionsId = null;

  @SerializedName("nBits")
  private Long nBits = null;

  @SerializedName("extensionHash")
  private String extensionHash = null;

  @SerializedName("extensionRoot")
  private String extensionRoot = null;

  @SerializedName("extensionId")
  private String extensionId = null;

  @SerializedName("height")
  private Integer height = null;

  @SerializedName("size")
  private Integer size = null;

  @SerializedName("parentId")
  private String parentId = null;

  @SerializedName("powSolutions")
  private PowSolutions powSolutions = null;

  @SerializedName("votes")
  private String votes = null;

  @SerializedName("minerPk")
  private String minerPk = null;

  @SerializedName("powOnetimePk")
  private String powOnetimePk = null;

  @SerializedName("powNonce")
  private String powNonce = null;

  @SerializedName("powDistance")
  private BigDecimal powDistance = null;

  public SigmaHeader id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public SigmaHeader timestamp(Integer timestamp) {
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Get timestamp
   * @return timestamp
  **/
  @Schema(required = true, description = "")
  public Integer getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(Integer timestamp) {
    this.timestamp = timestamp;
  }

  public SigmaHeader version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @Schema(required = true, description = "")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public SigmaHeader adProofsRoot(String adProofsRoot) {
    this.adProofsRoot = adProofsRoot;
    return this;
  }

   /**
   * Get adProofsRoot
   * @return adProofsRoot
  **/
  @Schema(required = true, description = "")
  public String getAdProofsRoot() {
    return adProofsRoot;
  }

  public void setAdProofsRoot(String adProofsRoot) {
    this.adProofsRoot = adProofsRoot;
  }

  public SigmaHeader adProofsId(String adProofsId) {
    this.adProofsId = adProofsId;
    return this;
  }

   /**
   * Get adProofsId
   * @return adProofsId
  **/
  @Schema(description = "")
  public String getAdProofsId() {
    return adProofsId;
  }

  public void setAdProofsId(String adProofsId) {
    this.adProofsId = adProofsId;
  }

  public SigmaHeader stateRoot(AvlTreeData stateRoot) {
    this.stateRoot = stateRoot;
    return this;
  }

   /**
   * Get stateRoot
   * @return stateRoot
  **/
  @Schema(required = true, description = "")
  public AvlTreeData getStateRoot() {
    return stateRoot;
  }

  public void setStateRoot(AvlTreeData stateRoot) {
    this.stateRoot = stateRoot;
  }

  public SigmaHeader transactionsRoot(String transactionsRoot) {
    this.transactionsRoot = transactionsRoot;
    return this;
  }

   /**
   * Get transactionsRoot
   * @return transactionsRoot
  **/
  @Schema(required = true, description = "")
  public String getTransactionsRoot() {
    return transactionsRoot;
  }

  public void setTransactionsRoot(String transactionsRoot) {
    this.transactionsRoot = transactionsRoot;
  }

  public SigmaHeader transactionsId(String transactionsId) {
    this.transactionsId = transactionsId;
    return this;
  }

   /**
   * Get transactionsId
   * @return transactionsId
  **/
  @Schema(description = "")
  public String getTransactionsId() {
    return transactionsId;
  }

  public void setTransactionsId(String transactionsId) {
    this.transactionsId = transactionsId;
  }

  public SigmaHeader nBits(Long nBits) {
    this.nBits = nBits;
    return this;
  }

   /**
   * Get nBits
   * minimum: 0
   * @return nBits
  **/
  @Schema(example = "19857408", required = true, description = "")
  public Long getNBits() {
    return nBits;
  }

  public void setNBits(Long nBits) {
    this.nBits = nBits;
  }

  public SigmaHeader extensionHash(String extensionHash) {
    this.extensionHash = extensionHash;
    return this;
  }

   /**
   * Get extensionHash
   * @return extensionHash
  **/
  @Schema(required = true, description = "")
  public String getExtensionHash() {
    return extensionHash;
  }

  public void setExtensionHash(String extensionHash) {
    this.extensionHash = extensionHash;
  }

  public SigmaHeader extensionRoot(String extensionRoot) {
    this.extensionRoot = extensionRoot;
    return this;
  }

   /**
   * Get extensionRoot
   * @return extensionRoot
  **/
  @Schema(description = "")
  public String getExtensionRoot() {
    return extensionRoot;
  }

  public void setExtensionRoot(String extensionRoot) {
    this.extensionRoot = extensionRoot;
  }

  public SigmaHeader extensionId(String extensionId) {
    this.extensionId = extensionId;
    return this;
  }

   /**
   * Get extensionId
   * @return extensionId
  **/
  @Schema(description = "")
  public String getExtensionId() {
    return extensionId;
  }

  public void setExtensionId(String extensionId) {
    this.extensionId = extensionId;
  }

  public SigmaHeader height(Integer height) {
    this.height = height;
    return this;
  }

   /**
   * Get height
   * minimum: 0
   * @return height
  **/
  @Schema(example = "667", required = true, description = "")
  public Integer getHeight() {
    return height;
  }

  public void setHeight(Integer height) {
    this.height = height;
  }

  public SigmaHeader size(Integer size) {
    this.size = size;
    return this;
  }

   /**
   * Get size
   * minimum: 0
   * @return size
  **/
  @Schema(example = "667", description = "")
  public Integer getSize() {
    return size;
  }

  public void setSize(Integer size) {
    this.size = size;
  }

  public SigmaHeader parentId(String parentId) {
    this.parentId = parentId;
    return this;
  }

   /**
   * Get parentId
   * @return parentId
  **/
  @Schema(required = true, description = "")
  public String getParentId() {
    return parentId;
  }

  public void setParentId(String parentId) {
    this.parentId = parentId;
  }

  public SigmaHeader powSolutions(PowSolutions powSolutions) {
    this.powSolutions = powSolutions;
    return this;
  }

   /**
   * Get powSolutions
   * @return powSolutions
  **/
  @Schema(description = "")
  public PowSolutions getPowSolutions() {
    return powSolutions;
  }

  public void setPowSolutions(PowSolutions powSolutions) {
    this.powSolutions = powSolutions;
  }

  public SigmaHeader votes(String votes) {
    this.votes = votes;
    return this;
  }

   /**
   * Get votes
   * @return votes
  **/
  @Schema(required = true, description = "")
  public String getVotes() {
    return votes;
  }

  public void setVotes(String votes) {
    this.votes = votes;
  }

  public SigmaHeader minerPk(String minerPk) {
    this.minerPk = minerPk;
    return this;
  }

   /**
   * Get minerPk
   * @return minerPk
  **/
  @Schema(example = "0279be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798", description = "")
  public String getMinerPk() {
    return minerPk;
  }

  public void setMinerPk(String minerPk) {
    this.minerPk = minerPk;
  }

  public SigmaHeader powOnetimePk(String powOnetimePk) {
    this.powOnetimePk = powOnetimePk;
    return this;
  }

   /**
   * Get powOnetimePk
   * @return powOnetimePk
  **/
  @Schema(example = "0279be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798", description = "")
  public String getPowOnetimePk() {
    return powOnetimePk;
  }

  public void setPowOnetimePk(String powOnetimePk) {
    this.powOnetimePk = powOnetimePk;
  }

  public SigmaHeader powNonce(String powNonce) {
    this.powNonce = powNonce;
    return this;
  }

   /**
   * Get powNonce
   * @return powNonce
  **/
  @Schema(description = "")
  public String getPowNonce() {
    return powNonce;
  }

  public void setPowNonce(String powNonce) {
    this.powNonce = powNonce;
  }

  public SigmaHeader powDistance(BigDecimal powDistance) {
    this.powDistance = powDistance;
    return this;
  }

   /**
   * sigma.BigInt
   * @return powDistance
  **/
  @Schema(example = "123456789", description = "sigma.BigInt")
  public BigDecimal getPowDistance() {
    return powDistance;
  }

  public void setPowDistance(BigDecimal powDistance) {
    this.powDistance = powDistance;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SigmaHeader sigmaHeader = (SigmaHeader) o;
    return Objects.equals(this.id, sigmaHeader.id) &&
        Objects.equals(this.timestamp, sigmaHeader.timestamp) &&
        Objects.equals(this.version, sigmaHeader.version) &&
        Objects.equals(this.adProofsRoot, sigmaHeader.adProofsRoot) &&
        Objects.equals(this.adProofsId, sigmaHeader.adProofsId) &&
        Objects.equals(this.stateRoot, sigmaHeader.stateRoot) &&
        Objects.equals(this.transactionsRoot, sigmaHeader.transactionsRoot) &&
        Objects.equals(this.transactionsId, sigmaHeader.transactionsId) &&
        Objects.equals(this.nBits, sigmaHeader.nBits) &&
        Objects.equals(this.extensionHash, sigmaHeader.extensionHash) &&
        Objects.equals(this.extensionRoot, sigmaHeader.extensionRoot) &&
        Objects.equals(this.extensionId, sigmaHeader.extensionId) &&
        Objects.equals(this.height, sigmaHeader.height) &&
        Objects.equals(this.size, sigmaHeader.size) &&
        Objects.equals(this.parentId, sigmaHeader.parentId) &&
        Objects.equals(this.powSolutions, sigmaHeader.powSolutions) &&
        Objects.equals(this.votes, sigmaHeader.votes) &&
        Objects.equals(this.minerPk, sigmaHeader.minerPk) &&
        Objects.equals(this.powOnetimePk, sigmaHeader.powOnetimePk) &&
        Objects.equals(this.powNonce, sigmaHeader.powNonce) &&
        Objects.equals(this.powDistance, sigmaHeader.powDistance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, timestamp, version, adProofsRoot, adProofsId, stateRoot, transactionsRoot, transactionsId, nBits, extensionHash, extensionRoot, extensionId, height, size, parentId, powSolutions, votes, minerPk, powOnetimePk, powNonce, powDistance);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SigmaHeader {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    adProofsRoot: ").append(toIndentedString(adProofsRoot)).append("\n");
    sb.append("    adProofsId: ").append(toIndentedString(adProofsId)).append("\n");
    sb.append("    stateRoot: ").append(toIndentedString(stateRoot)).append("\n");
    sb.append("    transactionsRoot: ").append(toIndentedString(transactionsRoot)).append("\n");
    sb.append("    transactionsId: ").append(toIndentedString(transactionsId)).append("\n");
    sb.append("    nBits: ").append(toIndentedString(nBits)).append("\n");
    sb.append("    extensionHash: ").append(toIndentedString(extensionHash)).append("\n");
    sb.append("    extensionRoot: ").append(toIndentedString(extensionRoot)).append("\n");
    sb.append("    extensionId: ").append(toIndentedString(extensionId)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    powSolutions: ").append(toIndentedString(powSolutions)).append("\n");
    sb.append("    votes: ").append(toIndentedString(votes)).append("\n");
    sb.append("    minerPk: ").append(toIndentedString(minerPk)).append("\n");
    sb.append("    powOnetimePk: ").append(toIndentedString(powOnetimePk)).append("\n");
    sb.append("    powNonce: ").append(toIndentedString(powNonce)).append("\n");
    sb.append("    powDistance: ").append(toIndentedString(powDistance)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
