/*
 * Decompiled with CFR 0.152.
 */
package org.errors4s.http4s.client;

import cats.FlatMap;
import cats.Functor;
import cats.data.EitherT;
import cats.implicits$;
import java.io.Serializable;
import org.errors4s.core.Error;
import org.errors4s.core.Error$;
import org.errors4s.core.NonEmptyString;
import org.errors4s.http4s.RedactionConfiguration;
import org.errors4s.http4s.client.ClientResponseError$;
import org.errors4s.http4s.client.ClientResponseError$ClientResponseErrorImpl$;
import org.http4s.Headers;
import org.http4s.Method;
import org.http4s.Status;
import scala.Function$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.StringContext;
import scala.StringContext$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public interface ClientResponseError<A>
extends Error {
    public Status status();

    public Option<RedactionConfiguration.RedactedRequestHeaders> requestHeaders();

    public Option<Method> requestMethod();

    public Option<RedactionConfiguration.RedactedUri> requestUri();

    public RedactionConfiguration.RedactedResponseHeaders responseHeaders();

    public EitherT<Option, Throwable, A> responseBodyT();

    public Function1<A, Option<String>> showResponseBody();

    public static boolean errorResponseHadBody$(ClientResponseError $this) {
        return $this.errorResponseHadBody();
    }

    default public boolean errorResponseHadBody() {
        return this.responseBody().isDefined();
    }

    public static Option responseBodyText$(ClientResponseError $this) {
        return $this.responseBodyText();
    }

    default public Option<String> responseBodyText() {
        Option option = Option$.MODULE$.empty();
        return (Option)this.responseBodyT().foldF((Function1 & Serializable)y -> (Option)Function$.MODULE$.const((Object)option, y), (Function1 & Serializable)a -> (Option)this.showResponseBody().apply(a), (FlatMap)implicits$.MODULE$.catsStdInstancesForOption());
    }

    public static Option responseBody$(ClientResponseError $this) {
        return $this.responseBody();
    }

    default public Option<Either<Throwable, A>> responseBody() {
        return (Option)this.responseBodyT().value();
    }

    public static Option requestHeadersValue$(ClientResponseError $this) {
        return $this.requestHeadersValue();
    }

    default public Option<List> requestHeadersValue() {
        return this.requestHeaders().map((Function1 & Serializable)_$1 -> new Headers(_$1.value()));
    }

    public static List responseHeadersValue$(ClientResponseError $this) {
        return $this.responseHeadersValue();
    }

    default public List responseHeadersValue() {
        return this.responseHeaders().value();
    }

    public static ClientResponseError map$(ClientResponseError $this, Function1 f, Function1 showResponseBody) {
        return $this.map(f, showResponseBody);
    }

    default public <B> ClientResponseError<B> map(Function1<A, B> f, Function1<B, Option<String>> showResponseBody) {
        return ClientResponseError$.MODULE$.apply(this.status(), this.requestHeaders(), this.requestMethod(), this.requestUri(), this.responseHeaders(), this.responseBodyT().map(f, (Functor)implicits$.MODULE$.catsStdInstancesForOption()), showResponseBody);
    }

    public static String primaryErrorMessage$(ClientResponseError $this) {
        return $this.primaryErrorMessage();
    }

    default public String primaryErrorMessage() {
        return (String)this.requestUri().flatMap((Function1 & Serializable)_$2 -> _$2.value().host().map((Function1 & Serializable)host -> {
            Left left;
            StringContext stringContext = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected response from HTTP call to ", ": ", ""}));
            if (StringContext$.MODULE$.standardInterpolator(ClientResponseError::primaryErrorMessage$$anonfun$3$$anonfun$1$$anonfun$1, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{host.renderString(), this.status()}), stringContext.parts()) == null) {
                left = package$.MODULE$.Left().apply((Object)"Given String value was null. This is not permitted for NonEmptyString values.");
            } else {
                StringContext stringContext2 = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected response from HTTP call to ", ": ", ""}));
                if (StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(StringContext$.MODULE$.standardInterpolator(ClientResponseError::primaryErrorMessage$$anonfun$4$$anonfun$2$$anonfun$2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{host.renderString(), this.status()}), stringContext2.parts()))) > 0) {
                    StringContext stringContext3 = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected response from HTTP call to ", ": ", ""}));
                    left = package$.MODULE$.Right().apply((Object)NonEmptyString.package.NonEmptyString$.MODULE$.unsafe(StringContext$.MODULE$.standardInterpolator(ClientResponseError::primaryErrorMessage$$anonfun$5$$anonfun$3$$anonfun$3, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{host.renderString(), this.status()}), stringContext3.parts())));
                } else {
                    left = package$.MODULE$.Left().apply((Object)"Unable to create NonEmptyString from empty string value.");
                }
            }
            return (String)left.getOrElse(ClientResponseError::primaryErrorMessage$$anonfun$6$$anonfun$4$$anonfun$4);
        })).getOrElse(this::primaryErrorMessage$$anonfun$2);
    }

    public static Vector secondaryErrorMessages$(ClientResponseError $this) {
        return $this.secondaryErrorMessages();
    }

    default public Vector<String> secondaryErrorMessages() {
        return (Vector)((IterableOps)((IterableOps)((IterableOps)((IterableOps)Option$.MODULE$.option2Iterable(this.requestUri().map((Function1 & Serializable)uri -> "Request URI: " + uri.value().renderString())).toVector().$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.requestMethod().map((Function1 & Serializable)method -> "Request Method: " + method.renderString())).toVector())).$plus$plus((IterableOnce)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Status: " + this.status()})))).$plus$plus((IterableOnce)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Response Headers: " + new Headers(this.responseHeaders().value())})))).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.requestHeaders().map((Function1 & Serializable)headers -> "Request Headers: " + new Headers(headers.value()))).toVector())).$plus$plus((IterableOnce)this.responseBodyText().fold(ClientResponseError::secondaryErrorMessages$$anonfun$4, (Function1 & Serializable)value -> (Vector)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Response Body: " + value.toString()}))));
    }

    public static Vector causes$(ClientResponseError $this) {
        return $this.causes();
    }

    default public Vector<Throwable> causes() {
        None$ none$ = None$.MODULE$;
        return Option$.MODULE$.option2Iterable((Option)this.responseBodyT().foldF((Function1 & Serializable)t -> {
            Left left;
            StringContext stringContext = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error occurred when attempting to decode the error response body."}));
            if (StringContext$.MODULE$.standardInterpolator(ClientResponseError::causes$$anonfun$3$$anonfun$1, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), stringContext.parts()) == null) {
                left = package$.MODULE$.Left().apply((Object)"Given String value was null. This is not permitted for NonEmptyString values.");
            } else {
                StringContext stringContext2 = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error occurred when attempting to decode the error response body."}));
                if (StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(StringContext$.MODULE$.standardInterpolator(ClientResponseError::causes$$anonfun$4$$anonfun$2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), stringContext2.parts()))) > 0) {
                    StringContext stringContext3 = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error occurred when attempting to decode the error response body."}));
                    left = package$.MODULE$.Right().apply((Object)NonEmptyString.package.NonEmptyString$.MODULE$.unsafe(StringContext$.MODULE$.standardInterpolator(ClientResponseError::causes$$anonfun$5$$anonfun$3, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), stringContext3.parts())));
                } else {
                    left = package$.MODULE$.Left().apply((Object)"Unable to create NonEmptyString from empty string value.");
                }
            }
            return Some$.MODULE$.apply((Object)Error$.MODULE$.withMessageAndCause((String)left.getOrElse(ClientResponseError::causes$$anonfun$6$$anonfun$4), t));
        }, (Function1 & Serializable)y -> (Option)Function$.MODULE$.const((Object)none$, y), (FlatMap)implicits$.MODULE$.catsStdInstancesForOption())).toVector();
    }

    public static String toString$(ClientResponseError $this) {
        return $this.toString();
    }

    default public String toString() {
        return "ClientResponseError(" + ((Throwable)((Object)this)).getLocalizedMessage() + ")";
    }

    private static String primaryErrorMessage$$anonfun$3$$anonfun$1$$anonfun$1(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String primaryErrorMessage$$anonfun$4$$anonfun$2$$anonfun$2(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String primaryErrorMessage$$anonfun$5$$anonfun$3$$anonfun$3(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String primaryErrorMessage$$anonfun$6$$anonfun$4$$anonfun$4() {
        throw new AssertionError((Object)"Error during macro expansion of StringContext `nes`. This is an errors4s-core bug. Please report it.");
    }

    private static String primaryErrorMessage$$anonfun$8$$anonfun$1(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String primaryErrorMessage$$anonfun$9$$anonfun$2(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String primaryErrorMessage$$anonfun$10$$anonfun$3(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String primaryErrorMessage$$anonfun$11$$anonfun$4() {
        throw new AssertionError((Object)"Error during macro expansion of StringContext `nes`. This is an errors4s-core bug. Please report it.");
    }

    private String primaryErrorMessage$$anonfun$2() {
        Left left;
        StringContext stringContext = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected response from HTTP call: ", ""}));
        if (StringContext$.MODULE$.standardInterpolator(ClientResponseError::primaryErrorMessage$$anonfun$8$$anonfun$1, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.status()}), stringContext.parts()) == null) {
            left = package$.MODULE$.Left().apply((Object)"Given String value was null. This is not permitted for NonEmptyString values.");
        } else {
            StringContext stringContext2 = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected response from HTTP call: ", ""}));
            if (StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(StringContext$.MODULE$.standardInterpolator(ClientResponseError::primaryErrorMessage$$anonfun$9$$anonfun$2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.status()}), stringContext2.parts()))) > 0) {
                StringContext stringContext3 = StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected response from HTTP call: ", ""}));
                left = package$.MODULE$.Right().apply((Object)NonEmptyString.package.NonEmptyString$.MODULE$.unsafe(StringContext$.MODULE$.standardInterpolator(ClientResponseError::primaryErrorMessage$$anonfun$10$$anonfun$3, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.status()}), stringContext3.parts())));
            } else {
                left = package$.MODULE$.Left().apply((Object)"Unable to create NonEmptyString from empty string value.");
            }
        }
        return (String)left.getOrElse(ClientResponseError::primaryErrorMessage$$anonfun$11$$anonfun$4);
    }

    private static Vector secondaryErrorMessages$$anonfun$4() {
        return package$.MODULE$.Vector().empty();
    }

    private static String causes$$anonfun$3$$anonfun$1(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String causes$$anonfun$4$$anonfun$2(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String causes$$anonfun$5$$anonfun$3(String str) {
        return StringContext$.MODULE$.processEscapes(str);
    }

    private static String causes$$anonfun$6$$anonfun$4() {
        throw new AssertionError((Object)"Error during macro expansion of StringContext `nes`. This is an errors4s-core bug. Please report it.");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class ClientResponseErrorImpl<A>
    extends RuntimeException
    implements ClientResponseError<A>,
    Product {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(ClientResponseErrorImpl.class, "0bitmap$1");
        public Vector causesErrorMessages$lzy1;
        public long 0bitmap$1;
        public Vector errorMessages$lzy1;
        public String getMessageNes$lzy1;
        public String getMessage$lzy1;
        public Throwable getCause$lzy1;
        private final Status status;
        private final Option requestHeaders;
        private final Option requestMethod;
        private final Option requestUri;
        private final RedactionConfiguration.RedactedResponseHeaders responseHeaders;
        private final EitherT responseBodyT;
        private final Function1 showResponseBody;

        public static <A> ClientResponseErrorImpl<A> apply(Status status, Option<RedactionConfiguration.RedactedRequestHeaders> option, Option<Method> option2, Option<RedactionConfiguration.RedactedUri> option3, RedactionConfiguration.RedactedResponseHeaders redactedResponseHeaders, EitherT<Option, Throwable, A> eitherT, Function1<A, Option<String>> function1) {
            return ClientResponseError$ClientResponseErrorImpl$.MODULE$.apply(status, option, option2, option3, redactedResponseHeaders, eitherT, function1);
        }

        public static ClientResponseErrorImpl fromProduct(Product product) {
            return ClientResponseError$ClientResponseErrorImpl$.MODULE$.fromProduct(product);
        }

        public static <A> ClientResponseErrorImpl<A> unapply(ClientResponseErrorImpl<A> clientResponseErrorImpl) {
            return ClientResponseError$ClientResponseErrorImpl$.MODULE$.unapply(clientResponseErrorImpl);
        }

        public ClientResponseErrorImpl(Status status, Option<RedactionConfiguration.RedactedRequestHeaders> requestHeaders, Option<Method> requestMethod, Option<RedactionConfiguration.RedactedUri> requestUri, RedactionConfiguration.RedactedResponseHeaders responseHeaders, EitherT<Option, Throwable, A> responseBodyT, Function1<A, Option<String>> showResponseBody) {
            this.status = status;
            this.requestHeaders = requestHeaders;
            this.requestMethod = requestMethod;
            this.requestUri = requestUri;
            this.responseHeaders = responseHeaders;
            this.responseBodyT = responseBodyT;
            this.showResponseBody = showResponseBody;
        }

        public final Vector causesErrorMessages() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        Vector vector;
                        this.causesErrorMessages$lzy1 = vector = Error.causesErrorMessages$((Error)this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return vector;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.causesErrorMessages$lzy1;
        }

        public final Vector errorMessages() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                    try {
                        Vector vector;
                        this.errorMessages$lzy1 = vector = Error.errorMessages$((Error)this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                        return vector;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
            }
            return this.errorMessages$lzy1;
        }

        public final String getMessageNes() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 2)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 2)) continue;
                    try {
                        String string;
                        this.getMessageNes$lzy1 = string = Error.getMessageNes$((Error)this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 2);
                        return string;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 2);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 2);
            }
            return this.getMessageNes$lzy1;
        }

        @Override
        public final String getMessage() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 3)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 3)) continue;
                    try {
                        String string;
                        this.getMessage$lzy1 = string = Error.getMessage$((Error)this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 3);
                        return string;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 3);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 3);
            }
            return this.getMessage$lzy1;
        }

        @Override
        public final Throwable getCause() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 4)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 4)) continue;
                    try {
                        Throwable throwable;
                        this.getCause$lzy1 = throwable = Error.getCause$((Error)this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 4);
                        return throwable;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 4);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 4);
            }
            return this.getCause$lzy1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClientResponseErrorImpl)) return false;
            ClientResponseErrorImpl clientResponseErrorImpl = (ClientResponseErrorImpl)object;
            Status status = this.status();
            Status status2 = clientResponseErrorImpl.status();
            if (status == null) {
                if (status2 != null) {
                    return false;
                }
            } else if (!status.equals(status2)) return false;
            Option<RedactionConfiguration.RedactedRequestHeaders> option = this.requestHeaders();
            Option<RedactionConfiguration.RedactedRequestHeaders> option2 = clientResponseErrorImpl.requestHeaders();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Method> option3 = this.requestMethod();
            Option<Method> option4 = clientResponseErrorImpl.requestMethod();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<RedactionConfiguration.RedactedUri> option5 = this.requestUri();
            Option<RedactionConfiguration.RedactedUri> option6 = clientResponseErrorImpl.requestUri();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            RedactionConfiguration.RedactedResponseHeaders redactedResponseHeaders = this.responseHeaders();
            RedactionConfiguration.RedactedResponseHeaders redactedResponseHeaders2 = clientResponseErrorImpl.responseHeaders();
            if (redactedResponseHeaders == null) {
                if (redactedResponseHeaders2 != null) {
                    return false;
                }
            } else if (!redactedResponseHeaders.equals(redactedResponseHeaders2)) return false;
            EitherT<Option, Throwable, A> eitherT = this.responseBodyT();
            EitherT<Option, Throwable, A> eitherT2 = clientResponseErrorImpl.responseBodyT();
            if (eitherT == null) {
                if (eitherT2 != null) {
                    return false;
                }
            } else if (!eitherT.equals(eitherT2)) return false;
            Function1<A, Option<String>> function1 = this.showResponseBody();
            Function1<A, Option<String>> function12 = clientResponseErrorImpl.showResponseBody();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ClientResponseErrorImpl;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "ClientResponseErrorImpl";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = this._6();
                    break;
                }
                case 6: {
                    object = this._7();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "status";
                    break;
                }
                case 1: {
                    string = "requestHeaders";
                    break;
                }
                case 2: {
                    string = "requestMethod";
                    break;
                }
                case 3: {
                    string = "requestUri";
                    break;
                }
                case 4: {
                    string = "responseHeaders";
                    break;
                }
                case 5: {
                    string = "responseBodyT";
                    break;
                }
                case 6: {
                    string = "showResponseBody";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public Status status() {
            return this.status;
        }

        @Override
        public Option<RedactionConfiguration.RedactedRequestHeaders> requestHeaders() {
            return this.requestHeaders;
        }

        @Override
        public Option<Method> requestMethod() {
            return this.requestMethod;
        }

        @Override
        public Option<RedactionConfiguration.RedactedUri> requestUri() {
            return this.requestUri;
        }

        @Override
        public RedactionConfiguration.RedactedResponseHeaders responseHeaders() {
            return this.responseHeaders;
        }

        @Override
        public EitherT<Option, Throwable, A> responseBodyT() {
            return this.responseBodyT;
        }

        @Override
        public Function1<A, Option<String>> showResponseBody() {
            return this.showResponseBody;
        }

        public <A> ClientResponseErrorImpl<A> copy(Status status, Option<RedactionConfiguration.RedactedRequestHeaders> requestHeaders, Option<Method> requestMethod, Option<RedactionConfiguration.RedactedUri> requestUri, RedactionConfiguration.RedactedResponseHeaders responseHeaders, EitherT<Option, Throwable, A> responseBodyT, Function1<A, Option<String>> showResponseBody) {
            return new ClientResponseErrorImpl<A>(status, requestHeaders, requestMethod, requestUri, responseHeaders, responseBodyT, showResponseBody);
        }

        public <A> Status copy$default$1() {
            return this.status();
        }

        public <A> Option<RedactionConfiguration.RedactedRequestHeaders> copy$default$2() {
            return this.requestHeaders();
        }

        public <A> Option<Method> copy$default$3() {
            return this.requestMethod();
        }

        public <A> Option<RedactionConfiguration.RedactedUri> copy$default$4() {
            return this.requestUri();
        }

        public <A> RedactionConfiguration.RedactedResponseHeaders copy$default$5() {
            return this.responseHeaders();
        }

        public <A> EitherT<Option, Throwable, A> copy$default$6() {
            return this.responseBodyT();
        }

        public <A> Function1<A, Option<String>> copy$default$7() {
            return this.showResponseBody();
        }

        public Status _1() {
            return this.status();
        }

        public Option<RedactionConfiguration.RedactedRequestHeaders> _2() {
            return this.requestHeaders();
        }

        public Option<Method> _3() {
            return this.requestMethod();
        }

        public Option<RedactionConfiguration.RedactedUri> _4() {
            return this.requestUri();
        }

        public RedactionConfiguration.RedactedResponseHeaders _5() {
            return this.responseHeaders();
        }

        public EitherT<Option, Throwable, A> _6() {
            return this.responseBodyT();
        }

        public Function1<A, Option<String>> _7() {
            return this.showResponseBody();
        }
    }
}

