/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.esbtools.eventhandler.FutureDoneCallback;
import org.esbtools.eventhandler.FutureTransform;
import org.esbtools.eventhandler.TransformableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FailedTransformableFuture<T>
implements TransformableFuture<T> {
    private final Exception exception;
    private static final Logger log = LoggerFactory.getLogger(FailedTransformableFuture.class);

    public FailedTransformableFuture(Exception exception) {
        this.exception = exception;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        throw new ExecutionException(this.exception);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new ExecutionException(this.exception);
    }

    @Override
    public <U> TransformableFuture<U> transformSync(FutureTransform<T, U> futureTransform) {
        return new FailedTransformableFuture<T>(this.exception);
    }

    @Override
    public <U> TransformableFuture<U> transformAsync(FutureTransform<T, TransformableFuture<U>> futureTransform) {
        return new FailedTransformableFuture<T>(this.exception);
    }

    @Override
    public TransformableFuture<Void> transformAsyncIgnoringReturn(FutureTransform<T, TransformableFuture<?>> futureTransform) {
        return new FailedTransformableFuture<Void>(this.exception);
    }

    @Override
    public TransformableFuture<T> whenDoneOrCancelled(FutureDoneCallback callback) {
        try {
            callback.onDoneOrCancelled();
        }
        catch (Exception e) {
            log.warn("Exception caught and ignored while running future done callback.", (Throwable)e);
        }
        return this;
    }
}

