/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.esbtools.eventhandler.FailedTransformableFuture;
import org.esbtools.eventhandler.FutureDoneCallback;
import org.esbtools.eventhandler.FutureTransform;
import org.esbtools.eventhandler.TransformableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImmediateTransformableFuture<T>
implements TransformableFuture<T> {
    private final T result;
    private static final Logger log = LoggerFactory.getLogger(ImmediateTransformableFuture.class);

    public ImmediateTransformableFuture(T result) {
        this.result = result;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.result;
    }

    @Override
    public <U> TransformableFuture<U> transformSync(FutureTransform<T, U> futureTransform) {
        try {
            return new ImmediateTransformableFuture<U>(futureTransform.transform(this.result));
        }
        catch (Exception e) {
            return new FailedTransformableFuture(e);
        }
    }

    @Override
    public <U> TransformableFuture<U> transformAsync(FutureTransform<T, TransformableFuture<U>> futureTransform) {
        try {
            return futureTransform.transform(this.result);
        }
        catch (Exception e) {
            return new FailedTransformableFuture(e);
        }
    }

    @Override
    public TransformableFuture<Void> transformAsyncIgnoringReturn(FutureTransform<T, TransformableFuture<?>> futureTransform) {
        try {
            return futureTransform.transform(this.result);
        }
        catch (Exception e) {
            return new FailedTransformableFuture<Void>(e);
        }
    }

    @Override
    public TransformableFuture<T> whenDoneOrCancelled(FutureDoneCallback callback) {
        try {
            callback.onDoneOrCancelled();
        }
        catch (Exception e) {
            log.warn("Exception caught and ignored while running future done callback.", (Throwable)e);
        }
        return this;
    }
}

