/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.esbtools.eventhandler.DocumentEvent;
import org.esbtools.eventhandler.DocumentEventRepository;
import org.esbtools.eventhandler.FailedDocumentEvent;

public class PollingDocumentEventProcessorRoute
extends RouteBuilder {
    private final DocumentEventRepository documentEventRepository;
    private final Duration pollingInterval;
    private final int batchSize;
    private final String documentEndpoint;
    private final String failureEndpoint;
    private static final AtomicInteger idCounter = new AtomicInteger(1);
    private final int id = idCounter.getAndIncrement();

    public PollingDocumentEventProcessorRoute(DocumentEventRepository documentEventRepository, Duration pollingInterval, int batchSize, String documentEndpoint, String failureEndpoint) {
        this.documentEventRepository = documentEventRepository;
        this.pollingInterval = pollingInterval;
        this.batchSize = batchSize;
        this.documentEndpoint = documentEndpoint;
        this.failureEndpoint = failureEndpoint;
    }

    public void configure() throws Exception {
        ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("timer:pollForDocumentEvents" + this.id + "?period=" + this.pollingInterval.toMillis()).routeId("documentEventProcessor-" + this.id).process(exchange -> {
            ArrayList<FailedDocumentEvent> arrayList;
            HashMap eventsToDocuments;
            block11: {
                List<? extends DocumentEvent> documentEvents = this.documentEventRepository.retrievePriorityDocumentEventsUpTo(this.batchSize);
                HashMap<DocumentEvent, Future<Object>> eventsToFutureDocuments = new HashMap<DocumentEvent, Future<Object>>(documentEvents.size());
                for (DocumentEvent documentEvent : documentEvents) {
                    try {
                        eventsToFutureDocuments.put(documentEvent, documentEvent.lookupDocument());
                    }
                    catch (Exception e) {
                        this.log.error("Failed to get future document for document event: " + documentEvent, (Throwable)e);
                        eventsToFutureDocuments.put(documentEvent, (Future<Object>)Futures.immediateFailedFuture((Throwable)e));
                    }
                }
                eventsToDocuments = new HashMap(documentEvents.size());
                arrayList = new ArrayList<FailedDocumentEvent>();
                for (Map.Entry eventToFutureDocument : eventsToFutureDocuments.entrySet()) {
                    DocumentEvent event = (DocumentEvent)eventToFutureDocument.getKey();
                    Future futureDoc = (Future)eventToFutureDocument.getValue();
                    try {
                        eventsToDocuments.put(event, futureDoc.get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this.log.error("Failed to get document for document event: " + event, (Throwable)e);
                        arrayList.add(new FailedDocumentEvent(event, e));
                    }
                }
                try {
                    this.documentEventRepository.markDocumentEventsPublishedOrFailed(Collections.emptyList(), arrayList);
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block11;
                    this.log.error("Failed to update failed events. They will be reprocessed. Failures were: " + arrayList, (Throwable)e);
                }
            }
            Iterator eventsToDocumentsIterator = eventsToDocuments.entrySet().iterator();
            while (eventsToDocumentsIterator.hasNext()) {
                Map.Entry eventToDocument = eventsToDocumentsIterator.next();
                try {
                    this.documentEventRepository.ensureTransactionActive((DocumentEvent)eventToDocument.getKey());
                }
                catch (Exception e) {
                    eventsToDocumentsIterator.remove();
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("Event transaction no longer active, not processing: " + eventToDocument.getKey(), (Throwable)e);
                }
            }
            this.log.debug("Publishing {} documents on route {}: {}", new Object[]{eventsToDocuments.size(), exchange.getFromRouteId(), eventsToDocuments.values()});
            exchange.getIn().setBody((Object)Iterables.concat(eventsToDocuments.entrySet(), arrayList));
        })).split((Expression)this.body()).streaming().choice().when(e -> e.getIn().getBody() instanceof FailedDocumentEvent).to(this.failureEndpoint)).otherwise().process(exchange -> {
            Map.Entry eventToDocument = (Map.Entry)exchange.getIn().getBody(Map.Entry.class);
            exchange.setProperty("originalEvent", eventToDocument.getKey());
            exchange.getIn().setBody(eventToDocument.getValue());
        })).to(this.documentEndpoint)).process(exchange -> {
            DocumentEvent event = (DocumentEvent)exchange.getProperty("originalEvent", DocumentEvent.class);
            if (event == null) {
                throw new IllegalStateException("Could not get original event from exchange. Won't update event status as published. Exchange was: " + exchange);
            }
            this.documentEventRepository.markDocumentEventsPublishedOrFailed(Collections.singleton(event), Collections.emptyList());
        });
    }
}

