/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.esbtools.eventhandler.FailedMessage;
import org.esbtools.eventhandler.Message;

public class RetryingBatchFailedMessageRoute
extends RouteBuilder {
    private final String fromUri;
    private final Expression retryDelayMillis;
    private final int maxRetryCount;
    private final Duration processTimeout;
    private final String deadLetterUri;
    private final int idCount = idCounter.getAndIncrement();
    private final String routeId = "failedMessageRetryer-" + this.idCount;
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    private static final String NEXT_ATTEMPT_NUMBER_PROPERTY = "nextAttemptNumber";
    private static final Integer FIRST_ATTEMPT_NUMBER = 1;

    public RetryingBatchFailedMessageRoute(String fromUri, Expression retryDelayMillis, int maxRetryCount, Duration processTimeout, String deadLetterUri) {
        this.fromUri = fromUri;
        this.retryDelayMillis = retryDelayMillis;
        this.maxRetryCount = maxRetryCount;
        this.processTimeout = processTimeout;
        this.deadLetterUri = deadLetterUri;
    }

    public void configure() throws Exception {
        ((ExpressionNode)this.from(this.fromUri).routeId(this.routeId).loopDoWhile(PredicateBuilder.and((Predicate)this.exchangeHasFailures(), (Predicate)PredicateBuilder.not((Predicate)this.maxRetryCountMet()))).delay(this.retryDelayMillis).process(exchange -> {
            Integer retryAttempt = (Integer)Optional.ofNullable(exchange.getProperty(NEXT_ATTEMPT_NUMBER_PROPERTY, Integer.class)).orElse(FIRST_ATTEMPT_NUMBER);
            exchange.setProperty(NEXT_ATTEMPT_NUMBER_PROPERTY, (Object)(retryAttempt + 1));
            Collection oldFailures = (Collection)exchange.getIn().getMandatoryBody(Collection.class);
            ArrayList<FailedMessage> newFailures = new ArrayList<FailedMessage>();
            ArrayList<ReprocessingFailure> reprocessingFailures = new ArrayList<ReprocessingFailure>(oldFailures.size());
            this.log.debug("About to retry {} messages on route {}, attempt #{}: {}", new Object[]{oldFailures.size(), this.routeId, retryAttempt, oldFailures});
            for (Object failureAsObject : oldFailures) {
                Future<Void> reprocessingFuture;
                if (!(failureAsObject instanceof FailedMessage)) {
                    throw new IllegalArgumentException("Messages sent to " + RetryingBatchFailedMessageRoute.class + " route should be collections of FailedMessage elements, but got collection of " + failureAsObject.getClass());
                }
                FailedMessage failure = (FailedMessage)failureAsObject;
                Optional<Message> maybeMessage = failure.parsedMessage();
                if (!maybeMessage.isPresent()) {
                    this.log.warn("Failed message had no parsed message. There is no message to retry without trying to parse again, which is usually fruitless. Sending to dead letter URI {}.", (Object)this.deadLetterUri);
                    continue;
                }
                Message message = maybeMessage.get();
                try {
                    reprocessingFuture = message.process();
                }
                catch (Exception e) {
                    this.log.error("Failed to reprocess message (retry attempt #" + retryAttempt + "): " + message, (Throwable)e);
                    this.suppressPreviousFailureInNewException(failure, e);
                    newFailures.add(new FailedMessage(failure.originalMessage(), message, e));
                    continue;
                }
                reprocessingFailures.add(new ReprocessingFailure(failure, reprocessingFuture));
            }
            ArrayList<Message> reprocessedSuccessfully = this.log.isDebugEnabled() ? new ArrayList<Message>(reprocessingFailures.size()) : Collections.emptyList();
            for (ReprocessingFailure reprocessingFailure : reprocessingFailures) {
                Message parsedMessage;
                FailedMessage originalFailure = reprocessingFailure.originalFailure;
                try {
                    reprocessingFailure.reprocessingFuture.get(this.processTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    if (!this.log.isDebugEnabled()) continue;
                    reprocessedSuccessfully.add(originalFailure.parsedMessage().get());
                }
                catch (ExecutionException e) {
                    parsedMessage = originalFailure.parsedMessage().get();
                    this.log.error("Failed to reprocess message (retry attempt #" + retryAttempt + "): " + parsedMessage, (Throwable)e);
                    Throwable realException = e.getCause();
                    this.suppressPreviousFailureInNewException(originalFailure, realException);
                    FailedMessage failure = new FailedMessage(originalFailure.originalMessage(), parsedMessage, realException);
                    newFailures.add(failure);
                }
                catch (InterruptedException | TimeoutException e) {
                    parsedMessage = originalFailure.parsedMessage().get();
                    this.log.warn("Timed out reprocessing message (retry attempt #" + retryAttempt + "): " + parsedMessage, (Throwable)e);
                    this.suppressPreviousFailureInNewException(originalFailure, e);
                    FailedMessage failure = new FailedMessage(originalFailure.originalMessage(), parsedMessage, e);
                    newFailures.add(failure);
                }
            }
            this.log.debug("Retry attempt #{} successfully processed {}/{} messages on route {}: {}", new Object[]{retryAttempt, reprocessedSuccessfully.size(), oldFailures.size(), this.routeId, reprocessedSuccessfully});
            exchange.getIn().setBody(newFailures);
        })).end().end().filter(this.exchangeHasFailures()).to(this.deadLetterUri);
    }

    private void suppressPreviousFailureInNewException(FailedMessage previousMsg, Throwable _new) {
        Throwable previous = previousMsg.exception();
        if (RetryingBatchFailedMessageRoute.areExceptionsEqual(_new, previous)) {
            Arrays.stream(previous.getSuppressed()).filter(e -> e != _new).forEach(_new::addSuppressed);
        } else {
            _new.addSuppressed(previous);
        }
    }

    private Predicate maxRetryCountMet() {
        return new Predicate(){

            public boolean matches(Exchange exchange) {
                Integer nextAttemptNumber = (Integer)Optional.ofNullable(exchange.getProperty(RetryingBatchFailedMessageRoute.NEXT_ATTEMPT_NUMBER_PROPERTY, Integer.class)).orElse(FIRST_ATTEMPT_NUMBER);
                return nextAttemptNumber - FIRST_ATTEMPT_NUMBER >= RetryingBatchFailedMessageRoute.this.maxRetryCount;
            }
        };
    }

    private Predicate exchangeHasFailures() {
        return new Predicate(){

            public boolean matches(Exchange exchange) {
                Collection failures = (Collection)exchange.getIn().getBody(Collection.class);
                return failures != null && !failures.isEmpty();
            }
        };
    }

    private static boolean areExceptionsEqual(@Nullable Throwable t1, @Nullable Throwable t2) {
        if (t1 == t2 || Objects.equals(t1, t2)) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (!Objects.equals(t1.getMessage(), t2.getMessage())) {
            return false;
        }
        if (!Objects.equals(t1.getClass(), t2.getClass())) {
            return false;
        }
        if (!Objects.deepEquals(t1.getStackTrace(), t2.getStackTrace())) {
            return false;
        }
        return RetryingBatchFailedMessageRoute.areExceptionsEqual(t1.getCause(), t2.getCause());
    }

    private static final class ReprocessingFailure {
        private final FailedMessage originalFailure;
        private final Future<Void> reprocessingFuture;

        private ReprocessingFailure(FailedMessage originalFailure, Future<Void> reprocessingFuture) {
            this.originalFailure = originalFailure;
            this.reprocessingFuture = reprocessingFuture;
        }

        public String toString() {
            return "ReprocessingFailure{originalFailure=" + this.originalFailure + '}';
        }
    }
}

