/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler;

import java.util.Objects;
import java.util.Optional;
import org.esbtools.eventhandler.Message;

public final class FailedMessage {
    private final Object originalMessage;
    private final Optional<Message> parsedMessage;
    private final Throwable exception;

    public FailedMessage(Object originalMessage, Message parsedMessage, Throwable exception) {
        this.originalMessage = originalMessage;
        this.parsedMessage = Optional.of(parsedMessage);
        this.exception = exception;
    }

    public FailedMessage(Object originalMessage, Throwable exception) {
        this.originalMessage = originalMessage;
        this.parsedMessage = Optional.empty();
        this.exception = exception;
    }

    public Object originalMessage() {
        return this.originalMessage;
    }

    public Optional<Message> parsedMessage() {
        return this.parsedMessage;
    }

    public Throwable exception() {
        return this.exception;
    }

    public String toString() {
        return "FailedMessage{exception=" + this.exception + ", parsedMessage=" + this.parsedMessage + ", originalMessage=" + this.originalMessage + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedMessage that = (FailedMessage)o;
        return Objects.equals(this.originalMessage, that.originalMessage) && Objects.equals(this.parsedMessage, that.parsedMessage) && Objects.equals(this.exception, that.exception);
    }

    public int hashCode() {
        return Objects.hash(this.originalMessage, this.parsedMessage, this.exception);
    }
}

