/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.redhat.lightblue.generator.Description;
import com.redhat.lightblue.generator.EntityName;
import com.redhat.lightblue.generator.Identity;
import com.redhat.lightblue.generator.MinItems;
import com.redhat.lightblue.generator.Required;
import com.redhat.lightblue.generator.Transient;
import com.redhat.lightblue.generator.Version;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@EntityName(value="documentEvent")
@Version(value="0.1.1", preferImplementationVersion=false, changelog="Initial release")
public class DocumentEventEntity {
    public static final String ENTITY_NAME = "documentEvent";
    public static final String VERSION = Version.FromAnnotation.onEntity(DocumentEventEntity.class);
    private String _id;
    private String canonicalType;
    private List<KeyAndValue> parameters;
    private Status status;
    private Integer priority;
    private ZonedDateTime creationDate;
    private ZonedDateTime processingDate;
    private ZonedDateTime processedDate;
    private Set<String> survivorOfIds;
    private String sourceNotificationId;
    private static final String LIGHTBLUE_DATE_FORMAT = "yyyyMMdd'T'HH:mm:ss.SSSZ";

    public static DocumentEventEntity newlyCreated(@Nullable String sourceNotificationId, String canonicalType, int priority, ZonedDateTime creationDate, KeyAndValue ... parameters) {
        DocumentEventEntity entity = new DocumentEventEntity();
        entity.setStatus(Status.unprocessed);
        entity.setCreationDate(creationDate);
        entity.setCanonicalType(canonicalType);
        entity.setPriority(priority);
        entity.setSourceNotificationId(sourceNotificationId);
        entity.setParameters(Arrays.asList(parameters));
        return entity;
    }

    public String get_id() {
        return this._id;
    }

    @Identity
    public void set_id(String _id) {
        this._id = _id;
    }

    public String getCanonicalType() {
        return this.canonicalType;
    }

    @Required
    public void setCanonicalType(String canonicalType) {
        this.canonicalType = canonicalType;
    }

    @Transient
    @Nullable
    public String getParameterByKey(String key) {
        for (KeyAndValue keyAndValue : this.parameters) {
            if (!Objects.equals(key, keyAndValue.getKey())) continue;
            return keyAndValue.getValue();
        }
        throw new NoSuchElementException(key);
    }

    public List<KeyAndValue> getParameters() {
        return this.parameters;
    }

    @Required
    @MinItems(value=1)
    public void setParameters(List<KeyAndValue> parameters) {
        this.parameters = parameters;
    }

    public Status getStatus() {
        return this.status;
    }

    @Required
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd'T'HH:mm:ss.SSSZ")
    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    @Required
    public void setCreationDate(ZonedDateTime creationDate) {
        this.creationDate = creationDate;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd'T'HH:mm:ss.SSSZ")
    public ZonedDateTime getProcessingDate() {
        return this.processingDate;
    }

    public void setProcessingDate(ZonedDateTime processingDate) {
        this.processingDate = processingDate;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyyMMdd'T'HH:mm:ss.SSSZ")
    public ZonedDateTime getProcessedDate() {
        return this.processedDate;
    }

    public void setProcessedDate(ZonedDateTime processedDate) {
        this.processedDate = processedDate;
    }

    public Integer getPriority() {
        return this.priority;
    }

    @Required
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Set<String> getSurvivorOfIds() {
        return this.survivorOfIds;
    }

    public void setSurvivorOfIds(Set<String> survivorOfIds) {
        this.survivorOfIds = survivorOfIds;
    }

    public void addSurvivorOfIds(String ... ids) {
        if (ids == null) {
            return;
        }
        if (this.survivorOfIds == null) {
            this.survivorOfIds = new HashSet<String>();
        }
        Collections.addAll(this.survivorOfIds, ids);
    }

    public void addSurvivorOfIds(@Nullable Collection<String> ids) {
        if (ids == null) {
            return;
        }
        if (this.survivorOfIds == null) {
            this.survivorOfIds = new HashSet<String>();
        }
        this.survivorOfIds.addAll(ids);
    }

    public String getSourceNotificationId() {
        return this.sourceNotificationId;
    }

    @Description(value="If this document event was created as a result of notification processing, this is the id of that notification. Document events can also be created either directly or as the result of a merge, and in those cases this will be null.")
    public void setSourceNotificationId(String sourceNotificationId) {
        this.sourceNotificationId = sourceNotificationId;
    }

    public String toString() {
        return "DocumentEventEntity{_id='" + this._id + '\'' + ", canonicalType='" + this.canonicalType + '\'' + ", parameters=" + this.parameters + ", status=" + (Object)((Object)this.status) + ", priority=" + this.priority + ", creationDate=" + this.creationDate + ", processingDate=" + this.processingDate + ", processedDate=" + this.processedDate + ", survivorOfIds=" + this.survivorOfIds + ", sourceNotificationId='" + this.sourceNotificationId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentEventEntity that = (DocumentEventEntity)o;
        return Objects.equals(this._id, that._id) && Objects.equals(this.canonicalType, that.canonicalType) && Objects.equals(this.parameters, that.parameters) && this.status == that.status && Objects.equals(this.priority, that.priority) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.processingDate, that.processingDate) && Objects.equals(this.processedDate, that.processedDate) && Objects.equals(this.survivorOfIds, that.survivorOfIds) && Objects.equals(this.sourceNotificationId, that.sourceNotificationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._id, this.canonicalType, this.parameters, this.status, this.priority, this.creationDate, this.processingDate, this.processedDate, this.survivorOfIds, this.sourceNotificationId});
    }

    public static class KeyAndValue {
        private String key;
        private String value;

        public KeyAndValue() {
        }

        public KeyAndValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        @Required
        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAndValue identityValue = (KeyAndValue)o;
            return Objects.equals(this.key, identityValue.key) && Objects.equals(this.value, identityValue.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "KeyAndValue{key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static enum Status {
        unprocessed,
        processing,
        published,
        superseded,
        merged,
        failed;

    }
}

