/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue;

import com.google.common.util.concurrent.Futures;
import java.util.Objects;
import java.util.concurrent.Future;
import org.esbtools.eventhandler.DocumentEvent;
import org.esbtools.eventhandler.lightblue.DocumentEventEntity;
import org.esbtools.eventhandler.lightblue.Identity;
import org.esbtools.eventhandler.lightblue.LightblueDocumentEvent;
import org.esbtools.eventhandler.lightblue.TypeAndValueIdentity;

public class UnparseableDocumentEvent
implements LightblueDocumentEvent {
    private final Exception exception;
    private final DocumentEventEntity entity;

    public UnparseableDocumentEvent(Exception exception, DocumentEventEntity entity) {
        this.exception = Objects.requireNonNull(exception, "exception");
        this.entity = Objects.requireNonNull(entity, "entity");
    }

    public Future<?> lookupDocument() {
        return Futures.immediateFailedFuture((Throwable)this.exception);
    }

    public boolean isSupersededBy(DocumentEvent event) {
        return false;
    }

    public boolean couldMergeWith(DocumentEvent event) {
        return false;
    }

    @Override
    public LightblueDocumentEvent merge(DocumentEvent event) {
        throw new UnsupportedOperationException("Cannot merge with failed event!");
    }

    @Override
    public Identity identity() {
        return new TypeAndValueIdentity(UnparseableDocumentEvent.class, this.entity.get_id());
    }

    @Override
    public DocumentEventEntity wrappedDocumentEventEntity() {
        return this.entity;
    }

    public String toString() {
        return "UnparseableDocumentEvent{exception=" + this.exception + ", entity=" + this.entity + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnparseableDocumentEvent that = (UnparseableDocumentEvent)o;
        return Objects.equals(this.exception, that.exception) && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(this.exception, this.entity);
    }
}

