/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.client;

import com.redhat.lightblue.client.model.DataError;
import com.redhat.lightblue.client.model.Error;
import com.redhat.lightblue.client.response.LightblueErrorResponse;
import com.redhat.lightblue.client.response.LightblueResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class LightblueErrors {
    public static boolean arePresentInResponse(LightblueResponse response) {
        if (response instanceof LightblueErrorResponse) {
            LightblueErrorResponse errorResponse = (LightblueErrorResponse)response;
            return errorResponse.hasDataErrors() || errorResponse.hasLightblueErrors();
        }
        return false;
    }

    public static List<String> toStringsFromErrorResponse(LightblueResponse response) {
        if (!(response instanceof LightblueErrorResponse)) {
            return Collections.emptyList();
        }
        LightblueErrorResponse errorResponse = (LightblueErrorResponse)response;
        ArrayList errors = new ArrayList();
        Error[] lightblueErrors = errorResponse.getLightblueErrors();
        DataError[] dataErrors = errorResponse.getDataErrors();
        if (lightblueErrors != null) {
            Collections.addAll(errors, lightblueErrors);
        }
        if (dataErrors != null) {
            Collections.addAll(errors, Arrays.stream(dataErrors).flatMap(dataError -> dataError.getErrors().stream()).toArray(Error[]::new));
        }
        return errors.stream().map(e -> "Code: " + e.getErrorCode() + ", Context: " + e.getContext() + ", Message: " + e.getMsg()).collect(Collectors.toList());
    }
}

