/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.redhat.lightblue.generator.Description;
import com.redhat.lightblue.generator.EntityName;
import com.redhat.lightblue.generator.Identity;
import com.redhat.lightblue.generator.Required;
import com.redhat.lightblue.generator.Transient;
import com.redhat.lightblue.generator.Version;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.esbtools.eventhandler.lightblue.LightblueDocumentEventRepositoryConfig;
import org.esbtools.eventhandler.lightblue.LightblueNotificationRepositoryConfig;

@EntityName(value="eventHandlerConfig")
@Version(value="0.1.1", preferImplementationVersion=false, changelog="Initial domain-specific config")
public class EventHandlerConfigEntity
implements LightblueNotificationRepositoryConfig,
LightblueDocumentEventRepositoryConfig {
    public static final String ENTITY_NAME = "eventHandlerConfig";
    public static final String ENTITY_VERSION = Version.FromAnnotation.onEntity(EventHandlerConfigEntity.class);
    private String domain;
    private Set<String> canonicalTypesToProcess;
    private Integer documentEventsBatchSize;
    private Set<String> entityNamesToProcess;
    private Integer notificationProcessingTimeoutSeconds;
    private Integer notificationExpireThresholdSeconds;
    private Integer documentEventProcessingTimeoutSeconds;
    private Integer documentEventExpireThresholdSeconds;
    private Integer maxDocumentEventsPerInsert;

    public String getDomain() {
        return this.domain;
    }

    @Identity
    @Required
    @Description(value="Identifies a set of configuration values. Since all config is contained in a single document in a collection, it is necessary to know how to refer to that document: you refer to it by its domain.")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public Set<String> getCanonicalTypesToProcess() {
        return this.canonicalTypesToProcess;
    }

    @Description(value="Governs whether or not document events are processed based on their type.")
    public void setCanonicalTypesToProcess(Set<String> canonicalTypesToProcess) {
        this.canonicalTypesToProcess = canonicalTypesToProcess;
    }

    @Override
    public Integer getDocumentEventsBatchSize() {
        return this.documentEventsBatchSize;
    }

    @Description(value="Not to be confused with the maximum number of document events passed to DocumentEventRepository.retrievePriorityDocumentEventsUpTo(int), this governs the max batch size of events fetched from lightblue and available for optimization.\nFor example, if you ask for 50 document events to be retrieved, and your batch size is 100, we will initially fetch 100 document events (assuming there are >= 100 events waiting to be processed) from lightblue. Among those 100, we will try to optimize away as many events as possible by checking for events which can be merged or superseded. Finally, among those left, we will return the 50 highest priority events. Any remaining events past 50 will be untouched, available for future retrievals.")
    public void setDocumentEventsBatchSize(Integer documentEventsBatchSize) {
        this.documentEventsBatchSize = documentEventsBatchSize;
    }

    @Override
    @Transient
    public Duration getDocumentEventProcessingTimeout() {
        return this.documentEventProcessingTimeoutSeconds == null ? null : Duration.ofSeconds(this.documentEventProcessingTimeoutSeconds.intValue());
    }

    public Integer getDocumentEventProcessingTimeoutSeconds() {
        return this.documentEventProcessingTimeoutSeconds;
    }

    @Description(value="How long can a document event remain processing before we allow it to be retrieved again for reprocessing?")
    public void setDocumentEventProcessingTimeoutSeconds(Integer documentEventProcessingTimeoutSeconds) {
        this.documentEventProcessingTimeoutSeconds = documentEventProcessingTimeoutSeconds;
    }

    @Override
    @Transient
    public Duration getDocumentEventExpireThreshold() {
        return this.documentEventExpireThresholdSeconds == null ? null : Duration.ofSeconds(this.documentEventExpireThresholdSeconds.intValue());
    }

    public Integer getDocumentEventExpireThresholdSeconds() {
        return this.documentEventExpireThresholdSeconds;
    }

    @Description(value="How long before a document event is available for retrieval do we drop the event and let it be reprocessed?\nIn other words, this governs when we stop processing an event in flight because we're too near when another retrieval may see it is past its getDocumentEventProcessingTimeout() and retrieve it for reprocessing.\nN.B. The existence of this configuration is a function of our current transaction scheme. This could go away, for instance, if we either atomically updated an event's processing timestamp before publishing its document. Other alternative schemes are possible.")
    public void setDocumentEventExpireThresholdSeconds(Integer documentEventExpireThresholdSeconds) {
        this.documentEventExpireThresholdSeconds = documentEventExpireThresholdSeconds;
    }

    @Override
    @Transient
    @JsonIgnore
    public Optional<Integer> getOptionalMaxDocumentEventsPerInsert() {
        return Optional.ofNullable(this.maxDocumentEventsPerInsert);
    }

    public Integer getMaxDocumentEventsPerInsert() {
        return this.maxDocumentEventsPerInsert;
    }

    @Description(value="When adding new document events, we can make (total new events) / (max events per insert) requests, instead of one request with all new events in a single call. If no integer is provided, we will do one request with all new events.\nSetting a limit is recommended as it protects against potentially extremely significant notifications producing a huge quantity of document events and failing to insert them all in one call.")
    public void setMaxDocumentEventsPerInsert(@Nullable Integer maxDocumentEventsPerInsert) {
        this.maxDocumentEventsPerInsert = maxDocumentEventsPerInsert;
    }

    @Override
    public Set<String> getEntityNamesToProcess() {
        return this.entityNamesToProcess;
    }

    @Description(value="Governs whether or not notifications are processed based on their associated entity's name.")
    public void setEntityNamesToProcess(Set<String> entityNamesToProcess) {
        this.entityNamesToProcess = entityNamesToProcess;
    }

    @Override
    @Transient
    public Duration getNotificationProcessingTimeout() {
        return this.notificationProcessingTimeoutSeconds == null ? null : Duration.ofSeconds(this.notificationProcessingTimeoutSeconds.intValue());
    }

    public Integer getNotificationProcessingTimeoutSeconds() {
        return this.notificationProcessingTimeoutSeconds;
    }

    @Description(value="How long can a notification remain processing before we allow it to be retrieved again for reprocessing?")
    public void setNotificationProcessingTimeoutSeconds(Integer notificationProcessingTimeoutSeconds) {
        this.notificationProcessingTimeoutSeconds = notificationProcessingTimeoutSeconds;
    }

    @Override
    @Transient
    public Duration getNotificationExpireThreshold() {
        return this.notificationExpireThresholdSeconds == null ? null : Duration.ofSeconds(this.notificationExpireThresholdSeconds.intValue());
    }

    public Integer getNotificationExpireThresholdSeconds() {
        return this.notificationExpireThresholdSeconds;
    }

    @Description(value="How long before a notification is available for retrieval do we drop the event and let it be reprocessed?\nIn other words, this governs when we stop processing a notification in flight because we're too near when another retrieval may see it is past its getNotificationProcessingTimeout() and retrieve it for reprocessing.\nN.B. The existence of this configuration is a function of our current transaction scheme. This could go away, for instance, if we either atomically updated a notification's processing timestamp before adding its document events. Other alternative schemes are possible.")
    public void setNotificationExpireThresholdSeconds(Integer notificationExpireThresholdSeconds) {
        this.notificationExpireThresholdSeconds = notificationExpireThresholdSeconds;
    }
}

