/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.locking;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.support.RoutePolicySupport;
import org.esbtools.eventhandler.lightblue.locking.LockNotAvailableException;
import org.esbtools.eventhandler.lightblue.locking.LockStrategy;
import org.esbtools.eventhandler.lightblue.locking.LockedResource;
import org.esbtools.eventhandler.lightblue.locking.LostLockException;

public class LockingRoutePolicy
extends RoutePolicySupport {
    private final String resourceId;
    private final LockStrategy lockStrategy;
    @Nullable
    private LockedResource<String> lock;

    public LockingRoutePolicy(String resourceId, LockStrategy lockStrategy) {
        this.resourceId = resourceId;
        this.lockStrategy = lockStrategy;
    }

    public void onStop(Route route) {
        this.releaseLock();
    }

    public void onSuspend(Route route) {
        this.releaseLock();
    }

    public synchronized void onExchangeBegin(Route route, Exchange exchange) {
        if (this.lock != null) {
            try {
                this.lock.ensureAcquiredOrThrow("Lost lock");
                return;
            }
            catch (LostLockException e) {
                this.log.warn("Lost lock w id: " + this.resourceId + ", trying to reacquire...", (Throwable)e);
                this.lock = null;
            }
        }
        try {
            this.lock = this.lockStrategy.tryAcquire(this.resourceId);
        }
        catch (LockNotAvailableException e) {
            this.log.debug("Lock not available, assuming another thread is holding lock w/ id: " + this.resourceId, (Throwable)e);
            exchange.setProperty("CamelRouteStop", (Object)Boolean.TRUE);
        }
    }

    private synchronized void releaseLock() {
        if (this.lock == null) {
            return;
        }
        try {
            this.lock.close();
        }
        catch (IOException e) {
            this.log.warn("IOException trying to release lock w/ identifier " + this.resourceId, (Throwable)e);
        }
        this.lock = null;
    }
}

