/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.locking;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.esbtools.eventhandler.lightblue.locking.LockedResource;

public class LostLockException
extends Exception {
    private final List<LockedResource> lostLocks;

    public LostLockException(LockedResource lock, String message) {
        super(message + " [Lock: " + lock + "]");
        this.lostLocks = Collections.singletonList(lock);
    }

    public LostLockException(LockedResource lock, String message, Exception cause) {
        super(message + " [Lock: " + lock + "]", cause);
        this.lostLocks = Collections.singletonList(lock);
    }

    public LostLockException(List<LostLockException> lostLockExceptions) {
        this.lostLocks = Collections.unmodifiableList(lostLockExceptions.stream().peek(this::addSuppressed).flatMap(e -> e.lostLocks().stream()).collect(Collectors.toList()));
    }

    public List<LockedResource> lostLocks() {
        return this.lostLocks;
    }
}

