/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common;

import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.LogFileMetricsLogger;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Ticker;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.EdiFactory;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeFactory;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public abstract class AbstractExchangeFactory<ORDER_REQ, CANCEL_REQ, ORDER_QUERY, CANDLE_REQ, TICKER extends Ticker, CEX extends Cex<ORDER_REQ, CANCEL_REQ, ORDER_QUERY> & ExchangeDataInterface<TICKER, CANDLE_REQ>, CONCRETE extends ExchangeFactory<ORDER_REQ, CANCEL_REQ, ORDER_QUERY, CEX> & EdiFactory<TICKER, CANDLE_REQ, CEX, CONCRETE>>
implements ExchangeFactory<ORDER_REQ, CANCEL_REQ, ORDER_QUERY, CEX>,
EdiFactory<TICKER, CANDLE_REQ, CEX, CONCRETE> {
    private final Exchange exchange;
    private final Map<EnvironmentType, List<URI>> hosts;
    protected MetricsLogger metricsLogger = new LogFileMetricsLogger();
    protected Proxy httpProxy;
    protected Long receiveWindow;
    protected String brokerId;
    protected Codec<Object> codec = new JacksonCodec();

    public AbstractExchangeFactory(Exchange exchange, Map<EnvironmentType, List<URI>> hosts) {
        this.exchange = exchange;
        this.hosts = hosts;
    }

    @NonNull
    protected JsonRestClient createJsonRestClient(URI uri) {
        return this.createJsonRestClient(uri, this.httpProxy);
    }

    @NonNull
    protected JsonRestClient createJsonRestClient(URI uri, Proxy httpProxy) {
        boolean isValidUri = this.hosts.values().stream().flatMap(Collection::stream).anyMatch(uri::equals);
        if (!isValidUri) {
            throw new IllegalArgumentException("Invalid URI for " + this.exchange.name() + ": " + uri);
        }
        return new JsonRestClient(uri, this.codec, httpProxy);
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public CONCRETE codec(Codec<Object> codec) {
        this.codec = codec;
        return this.me();
    }

    @Override
    public CONCRETE metricsLogger(MetricsLogger logger) {
        this.metricsLogger = logger;
        return this.me();
    }

    @Override
    public CONCRETE httpProxy(Proxy httpProxy) {
        this.httpProxy = httpProxy;
        return this.me();
    }

    @Override
    public CONCRETE httpProxy(URI httpProxy) {
        return this.httpProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxy.getHost(), httpProxy.getPort())));
    }

    @Override
    public CONCRETE receiveWindow(long receiveWindow) {
        this.receiveWindow = receiveWindow;
        return this.me();
    }

    @Override
    public CONCRETE brokerId(String brokerId) {
        this.brokerId = brokerId;
        return this.me();
    }

    protected abstract CONCRETE me();

    @Override
    public Map<EnvironmentType, List<URI>> getHosts() {
        return this.hosts;
    }

    public MetricsLogger getMetricsLogger() {
        return this.metricsLogger;
    }

    public Proxy getHttpProxy() {
        return this.httpProxy;
    }

    public Long getReceiveWindow() {
        return this.receiveWindow;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public Codec<Object> getCodec() {
        return this.codec;
    }
}

