/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common;

import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.stream.core.HeaderCreator;
import estonlabs.cxtl.common.stream.core.TyrusWebsocketConnection;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.ManagedWsSession;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.common.stream.pojo.PojoWebsocketConnection;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.lib.StreamFactory;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;

public abstract class AbstractStreamFactory<O extends OutboundMessage, I extends InboundMessage, CONCRETE extends AbstractStreamFactory<O, I, ?>>
implements StreamFactory<O, I> {
    protected final Exchange exchange;
    protected final Codec<Object> codec;
    protected final Class<I> type;
    protected Supplier<O> pingGenerator;
    protected Runnable ping;
    protected Supplier<O> pong;
    protected long pingWindow;
    protected long staleWindow = -1L;
    protected boolean expectPingResponse;
    protected Proxy httpProxy = null;

    public AbstractStreamFactory(Exchange exchange, Codec<Object> codec, Class<I> type) {
        this.exchange = exchange;
        this.codec = codec;
        this.type = type;
    }

    @Override
    public StreamFactory<O, I> ping(long pingWindow, @NonNull Runnable ping2, boolean expectPingResponse) {
        if (ping2 == null) {
            throw new NullPointerException("ping is marked non-null but is null");
        }
        this.pingWindow = pingWindow;
        this.ping = ping2;
        this.expectPingResponse = expectPingResponse;
        return this.me();
    }

    public CONCRETE ping(long pingWindow, @NonNull Supplier<O> pingGenerator) {
        if (pingGenerator == null) {
            throw new NullPointerException("pingGenerator is marked non-null but is null");
        }
        this.pingWindow = pingWindow;
        this.pingGenerator = pingGenerator;
        this.expectPingResponse = true;
        return this.me();
    }

    public CONCRETE pong(Supplier<O> pong) {
        this.pong = pong;
        return this.me();
    }

    public CONCRETE staleWindow(long staleWindow) {
        this.staleWindow = staleWindow;
        return this.me();
    }

    public CONCRETE httpProxy(Proxy httpProxy) {
        this.httpProxy = httpProxy;
        return this.me();
    }

    public CONCRETE httpProxy(URI httpProxy) {
        return (CONCRETE)this.httpProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxy.getHost(), httpProxy.getPort())));
    }

    protected WebsocketConnection<O, I> newPublicWebsocket(URI uri, HeaderCreator headerCreator) {
        return new PojoWebsocketConnection(new TyrusWebsocketConnection(uri, headerCreator, this.httpProxy), id -> this.createSession((String)id, null));
    }

    protected WebsocketConnection<O, I> newPrivateWebsocket(URI uri, HeaderCreator headerCreator) {
        return this.newPrivateWebsocket(uri, headerCreator, null);
    }

    protected WebsocketConnection<O, I> newPrivateWebsocketWithProxy(URI uri, Proxy httpProxy, HeaderCreator headerCreator) {
        return this.newPrivateWebsocket(uri, headerCreator, httpProxy, null);
    }

    protected WebsocketConnection<O, I> newPrivateWebsocket(URI uri, HeaderCreator headerCreator, Function<ManagedWsSession<O, I>, ManagedWsSession<O, I>> adapter) {
        return this.newPrivateWebsocket(uri, headerCreator, this.httpProxy, adapter);
    }

    protected WebsocketConnection<O, I> newPrivateWebsocket(URI uri, HeaderCreator headerCreator, Proxy httpProxy, Function<ManagedWsSession<O, I>, ManagedWsSession<O, I>> adapter) {
        return new PojoWebsocketConnection(new TyrusWebsocketConnection(uri, headerCreator, httpProxy), id -> this.createPrivateSession((String)id, adapter));
    }

    protected ManagedWsSession<O, I> createSession(String id, Function<ManagedWsSession<O, I>, ManagedWsSession<O, I>> adapter) {
        ManagedWsSession<O, I> session = new ManagedWsSession<O, I>(id, this.codec, this.type);
        if (this.pingGenerator != null) {
            session.enablePing(this.pingWindow, this.pingGenerator);
        } else if (this.ping != null) {
            session.enablePing(this.pingWindow, this.ping, this.expectPingResponse);
        }
        if (this.staleWindow > 0L) {
            session.enableStaleFeedCheck(this.staleWindow);
        }
        session.enablePong(this.pong);
        return adapter == null ? session : adapter.apply(session);
    }

    protected ManagedWsSession<O, I> createPrivateSession(String id, Function<ManagedWsSession<O, I>, ManagedWsSession<O, I>> adapter) {
        return this.createSession(id, adapter);
    }

    protected abstract CONCRETE me();

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    public Codec<Object> getCodec() {
        return this.codec;
    }

    public Class<I> getType() {
        return this.type;
    }

    public Supplier<O> getPingGenerator() {
        return this.pingGenerator;
    }

    public Runnable getPing() {
        return this.ping;
    }

    public Supplier<O> getPong() {
        return this.pong;
    }

    public long getPingWindow() {
        return this.pingWindow;
    }

    public long getStaleWindow() {
        return this.staleWindow;
    }

    public boolean isExpectPingResponse() {
        return this.expectPingResponse;
    }

    public Proxy getHttpProxy() {
        return this.httpProxy;
    }
}

