/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class DateFormatUtils {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss:SSS");
    private static final DateTimeFormatter NO_MS_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH:mm:ss");

    public static String toTime(long l) {
        return DateFormatUtils.toTime(l, true);
    }

    public static String toTime(long l, boolean showMs) {
        DateTimeFormatter f = showMs ? FORMATTER : NO_MS_FORMATTER;
        return f.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.systemDefault()));
    }

    public static String toDate(long l) {
        return DATE_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.systemDefault()));
    }

    public static String toDateTime(long l) {
        return DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneId.systemDefault()));
    }
}

