/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.codec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;

public class CaseInsensitiveEnumDeserializer<T extends Enum<T>>
extends JsonDeserializer<T> {
    private final Class<T> enumClass;

    public CaseInsensitiveEnumDeserializer(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String text = parser.getText();
        if (text == null || text.isBlank()) {
            return null;
        }
        T v = this.getValue(text, true);
        if (v == null) {
            v = this.getValue(text.toUpperCase(), false);
        }
        return v;
    }

    private T getValue(String text, boolean returnNull) throws IOException {
        try {
            return Enum.valueOf(this.enumClass, text);
        }
        catch (IllegalArgumentException e) {
            if (returnNull) {
                return null;
            }
            throw new IOException("Enum value not found for: " + text, e);
        }
    }
}

