/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import estonlabs.cxtl.common.codec.Codec;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonCodec
implements Codec<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonCodec.class);
    protected final ObjectMapper mapper = new ObjectMapper();

    @Override
    public <T> String toJson(T pojo) {
        try {
            return this.mapper.writeValueAsString(pojo);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> StringBuilder toQueryString(T pojo) {
        return this.toQueryString(pojo, new StringBuilder());
    }

    @Override
    public <T> Map<String, ?> toMap(T pojo) {
        return this.mapper.convertValue(pojo, Map.class);
    }

    @Override
    public <T> StringBuilder toQueryString(T pojo, StringBuilder builder) {
        if (pojo == null) {
            return null;
        }
        Map map = this.mapper.convertValue(pojo, Map.class);
        return JacksonCodec.mapToStringBuilder(map, builder);
    }

    @Override
    public <T> T fromJson(String json, Class<T> type) {
        try {
            return this.mapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error decoding " + json + " into type " + type, e);
            throw new RuntimeException("Error decoding " + json + " into type " + type, e);
        }
    }

    @Override
    public <T> T quietFromJson(String json, Class<T> type) {
        try {
            return this.mapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    @Override
    public <T> List<T> fromJsonArray(String json, Class<T> type) {
        try {
            return (List)this.mapper.readValue(json, (JavaType)this.mapper.getTypeFactory().constructCollectionLikeType(List.class, type));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error decoding " + json + " into type " + type, e);
        }
    }

    public static StringBuilder mapToStringBuilder(Map<String, ?> fields, StringBuilder builder) {
        TreeMap sortedFields = new TreeMap(fields);
        for (Map.Entry entry : sortedFields.entrySet()) {
            if (!builder.isEmpty()) {
                builder.append('&');
            }
            if (entry.getValue() == null) continue;
            builder.append((String)entry.getKey()).append('=').append(entry.getValue());
        }
        return builder;
    }
}

