/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.common.codec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import estonlabs.cxtl.common.codec.SubType;
import estonlabs.cxtl.common.codec.SubTypes;
import estonlabs.cxtl.common.codec.TypeInfo;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PolymorphicDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private JavaType type;

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        this.type = property != null ? property.getType() : ctxt.getContextualType();
        return this;
    }

    private Class<?> resolveConcreteType(Class<?> current, Function<String, String> fieldValueExtractor) {
        TypeInfo currentTypeInfo = current.getAnnotation(TypeInfo.class);
        if (currentTypeInfo == null) {
            return current;
        }
        SubTypes subTypes = current.getAnnotation(SubTypes.class);
        Map<String, Class> subTypesByDiscriminatorValue = Stream.of(subTypes.value()).collect(Collectors.toMap(SubType::name, SubType::value));
        String subTypeDiscriminatorProperty = currentTypeInfo.property();
        String discriminatorValue = fieldValueExtractor.apply(subTypeDiscriminatorProperty);
        Class subType = subTypesByDiscriminatorValue.get(discriminatorValue);
        return this.resolveConcreteType(subType, fieldValueExtractor);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        Class<?> deserializingType = this.type.getRawClass();
        Class<?> concreteType = this.resolveConcreteType(deserializingType, fieldName -> {
            JsonNode jsonNode = node.get((String)fieldName);
            return jsonNode.asText();
        });
        JsonParser parserOfNode = node.traverse(oc);
        Object concreteInstance = parserOfNode.readValueAs(concreteType);
        return concreteInstance;
    }
}

